#ifndef _SORT_LIST_TMP_H_
#define _SORT_LIST_TMP_H_

#include "sort_list.h"
#include "data_templ.h"

/*********************************************************************
 Merge Sort implementation
 *********************************************************************/

template <class type>
void sort_list<type>::merge_sort(type *temp, const int list1,
                                       const int size)
{
	int list2, size1, size2;
	
	if(size > 1) {
		list2 = list1 + size/2;
		size1 = list2 -list1;
		size2 = size - size1;
		merge_sort(temp, list1, size1);
		merge_sort(temp, list2, size2);
		merge(temp, list1, size1, list2, size2);
	}
}

template <class type>
void sort_list<type>::merge(type *temp, const int list1, const int size1,
                                        const int list2, const int size2)
{
	int i = list1, j = list2, k = list1;
	while(i < list1 + size1 && j < list2 + size2) {
		if(temp[i] < temp[j]) element[k++] = temp[i++];
		else                  element[k++] = temp[j++];
	}
	while(i < list1 + size1) element[k++] = temp[i++];
	while(j < list2 + size2) element[k++] = temp[j++];
	for(k = list1; k < list1 + size1 + size2; k++) temp[k] = element[k];
}

/*********************************************************************
 Quick Sort implementation
 *********************************************************************/
template <class type>
void sort_list<type>::swap(const int i, const int j)
{
  type temp = element[i];
  element[i] = element[j];
  element[j] = temp;
}

template <class type>
int sort_list<type>::partition(const int low, const int high)
{
  int pivot_loc, i;
  type pivot_key;
  
  pivot_key = element[low];
  pivot_loc = low;
  for(i=low+1; i<=high; ++i)
    if(element[i] < pivot_key) swap(++pivot_loc, i);
  swap(low, pivot_loc);
  return pivot_loc;
}

template <class type>
void sort_list<type>::quick_sort(const int low, const int high)
{
  int pivot_loc;

  if ( low < high ) {
    pivot_loc = partition(low, high);
    quick_sort(low, pivot_loc-1);
    quick_sort(pivot_loc+1, high);
  }
}

template <class type>
void sort_list<type>::sort()
{
  int n_swap = 0;

  // is it sorted already?
  for(int i = 0; i<array_size-1; ++i)
    if(element[i+1] < element[i])
	    ++n_swap;

  if(!n_swap) return;
  else if(n_swap < array_size/3) {
    // use merge-sort
		type *temp = new type[array_size];

		for(int i = 0; i < array_size; i++) temp[i] = element[i];
		merge_sort(temp, 0, array_size);
		
		delete [] temp;
	}
  else 
    // use quick-sort
	  quick_sort(0, array_size-1);
}

#endif




