#ifndef _SEARCHTMP_H_
#define _SEARCHTMP_H_

#include "search_list.h"
#include "sort_list_tmp.h"

template <class type>
int searchlist<type>::ssearch(const type &target) const
{
  for(int i = 0; i < array_size; ++i) {
    if(element[i] == target) return i;
  }
  return -1;
}

/*********************************************************************
 forgetful binary search
 *********************************************************************/
template <class type>
int searchlist<type>::bsearch(const type &target) const
{
  int top = array_size-1, bottom=0, middle;
  
  while(top > bottom) {
    middle = (top+bottom)/2;
    if(element[middle] < target) bottom = middle+1;
    else top = middle;
  }
  if(top == -1) return -1;
  if(element[top] == target) return top;
  else return -1;
}

/*********************************************************************
 less efficient binary search
 *********************************************************************/
template <class type>
int searchlist<type>::tsearch(const type &target) const
{
  int top = array_size-1, bottom=0, middle;
  
  while(top >= bottom) {
    middle = (top+bottom)/2;
    if(element[middle] == target) return middle;
    else if(element[middle] < target) bottom = middle+1;
    else top = middle-1;
  }
  return -1;
}

/*********************************************************************
 Binary search with range
 *********************************************************************/

/*********************************************************************
 forgetful binary search
 *********************************************************************/
template <class type>
int brsearch<type>::search(const type& target, int& range) const
{
  int id0, id1;
  
  range = 0;
  
  id0 = bsearch(target);
  
  if(id0 == -1) return -1;
  // return a range
  do {
    if(element[id0] != target) break;
    id0--;
  } while(id0>0);
  id0++;
  id1 = id0;
  while(id1<array_size) {
    if(element[id1] != target) break;
    id1++;
    range++;
  }
  return id0;
}

#endif




