#ifndef _SEARCH_LIST_H_
#define _SEARCH_LIST_H_

#include "sort_list.h"

// search algorithms
template <class type>
class searchlist : public sort_list<type>
{
  public :
    searchlist(int array_size = 10) :
      sort_list<type>(array_size) {}
    virtual ~searchlist() {}
    // different choices of searching functions
    virtual int ssearch(const type &target) const;
    virtual int bsearch(const type &target) const;
    virtual int tsearch(const type &target) const;
};

// derived class that returns a range, with sorting function
template <class type>
class brsearch : public searchlist<type>
{
  public :
    brsearch(int array_size = 1000) :
      searchlist<type>(array_size) {}
    virtual ~brsearch() {}
    virtual int search(const type& target) const
    { return bsearch(target);}
    // return a range
    virtual int search(const type& target, int& range) const;
};

#endif




