#include <stdlib.h>

#include "prune.h"
#include "rngblk.h"

int ring_block(int nat, int ncon, int **con, int flag[])
{
  int nkill = 0;
  register int i, j, k;
  int t0, t1, t2, ring_flag, this_ring = 0;
  int *visited = NULL, *travers = NULL;
  int *aux = NULL;
  
  aux = (int*) malloc(nat*sizeof(ncon));
  
  visited = (int*) malloc(nat*sizeof(int));
  travers = (int*) malloc(nat*sizeof(int));
  
  /*  PASS 1:
      identify all atoms in all rings */

  this_ring = 0;
  
  for(i=0; i<nat; ++i) {
    if(flag[i]) continue;
    for(k=ncon-1; k>0; --k) { /* pick reference atom to detect ring */
      if((t0 = con[i][k]) == NULL) continue;
      for(j=0; j<nat; ++j) visited[j] = 0;
      ring_flag = 0;
      t1 = 0;
      flag_ring(i, i, t0, ncon, con, visited, travers, &t1, &ring_flag);
      /* mark ring closure atoms */
       if(ring_flag) {
         flag[i] = flag[t0-1] = ++this_ring;
       }
    }  /* for(k) */
  }  /* for(i) */

  /* remove bridge atoms */
  for(i=0; i<nat-1; ++i) if(!flag[i]) kill_atom(i, nat, ncon, con);

  /* reset */
  for(i=0; i<nat; ++i) flag[i] = 0;

  /*  PASS 2:
      isolate and number blocks of rings */

  this_ring = 0;
  
  for(i=0; i<nat; ++i) {
    if(flag[i]) continue;
    /* detect atoms that cannot be in the same ring as "i" */
    for(k=0; k<ncon; ++k) aux[k] = 0;
    for(k=ncon-1; k>=0; --k) { /* pick reference atom to detect ring */
      if((t0 = con[i][k]) == NULL) continue;
      ring_flag = 0;
      for(j=0; j<nat; ++j) visited[j] = 0;
      t1 = 0;
      flag_ring(i, i, t0, ncon, con, visited, travers, &t1, &ring_flag);
      /* if two atoms connected to "i" are in a ring,
         then "i" is in the same ring */
      if(!ring_flag && k<ncon-1 && con[i][k+1]) {
        for(j=0; j<nat; ++j) visited[j] = 0;
        t1 = 0;
        /* walk back along the graph */
        visited[i] = 1;
        flag_ring(i, con[i][k+1]-1, t0, ncon, con, visited, travers, &t1, &ring_flag);
      }
      /* the atom in connection position "k" is an a ring with atom "i" */
      if(ring_flag) aux[k] = 1;
    }
    for(k=ncon-1; k>=0; --k) { /* pick reference atom to detect ring */
      if((t0 = con[i][k]) == NULL) continue;
      if(!aux[k]) continue;
      for(j=0; j<nat; ++j) visited[j] = 0;
      /* block position(s) that cannot be a ring */
      for(j=0; j<ncon; ++j) {
        if((t1=con[i][j]) == NULL) continue;
        /* if negative, connection "j" is not in a ring */
        if(!aux[j]) visited[con[i][j]-1] = 1;
      }
      ring_flag = 0;
      t1 = 0;
      flag_ring(i, i, t0, ncon, con, visited, travers, &t1, &ring_flag);
       if(ring_flag) {
        /* see if traversal has been visited already (fused rings) */
        t2 = 0;
        for(j=0; j<t1; ++j) {
          if((t2 = flag[travers[j]-1]) != NULL) break;
          if(travers[j] == t0) break;
        }
        /* update number of rings */
        this_ring = (!t2 ? this_ring+1 : t2);
        /* reduced traversal */
        for(j=0; j<t1; ++j) {
          /* assign current ring number to this atom */
/* printf("%d(%d) ", travers[j], flag[travers[j]-1]); */
          flag[travers[j]-1] = this_ring;
          /* ring is closed */
          if(travers[j] == t0) break;
        }
/* printf("\n"); */
      }
    }  /* for(k) */
  }  /* for(i) */

  for(i=0; i<nat; ++i) {
    if(flag[i] != NULL) ++nkill;
  }    

  free(visited);
  free(travers);
  
  free(aux);

  return(nkill);  /* number of atoms in a ring */
}

void flag_ring(int parent, int node, int target, int ncon, int **con,
               int visited[], int trav[], int *i_trav, int *flag)
/* Detect a ring by recursive depth-first traversal.
   This function works in one direction, so it detects only
   some of the ring-atoms. To reverse the direction, tamper with 
   the "visited" array.
 */
{
  register int k;
  int t0;

  /* add me to the traversal */
  trav[(*i_trav)++] = node+1;
  /* mark as visited */
  visited[node] = 1;

  for(k=0; k<ncon; ++k) {
    if((t0 = con[node][k]) == NULL) continue;
    if(visited[t0-1]) continue;
    /* a ring has been detected */
    if(node != parent && t0 == target) *flag = 1;
    flag_ring(parent, t0-1, target, ncon, con, visited, trav, i_trav, flag);
  }  /* for(k) */
}




