#include <stdlib.h>
#include <stdio.h>

#include "prune.h"

int pruned(int nat, int ncon, int **con, int flag[])
{
  int nkill = 0;
  register int i;
  
  for(i=0; i<nat; ++i) {
    if(flag[i] == NULL) {
      kill_term_at(i, nat, ncon, con, flag);
    }
  }

  for(i=0; i<nat; ++i) {
    if(flag[i] != NULL) ++nkill;
  }

  return(nkill);

}

void kill_term_at(int target, int nat, int ncon, int **con, int flag[])
/* removes terminal atoms from the connection table -- atoms belonging
 * to a chain between rings are *not* removed
 */
{
  register int i;
  int ndeg = 0, at0, at1;

  /* determine number of connections */
  for(i=0; i<ncon; ++i) {
    if(con[target][i] == NULL) continue;
    ++ndeg;
    at0 = con[target][i] - 1;
    at1 = i;
  }

  /* last atom */
  if(!ndeg) flag[target] = 1;
  /* not a terminal atom */
  if(ndeg != 1) return;
  
  /* flag this atom and strip its connection table */
  flag[target] = 1;
  con[target][at1] = 0;
  
  /* strip connection table of the connected atom */
  for(i=0; i<ncon; ++i) {
    if(con[at0][i] != target+1) continue;
    con[at0][i] = 0;
  }
  
  /* examine connected atom */
  kill_term_at(at0, nat, ncon, con, flag);

}

int kill_atom(int at0, int nat, int ncon, int **con)
{
  int snap1 = 0, snap2 = 0;
  register int i, k;

  for(k=0; k<ncon; ++k) {
    if(!con[at0][k]) continue;
    con[at0][k] = 0;
    ++snap1;
  }
  
  for(i=0; i<nat; ++i) {
    for(k=0; k<ncon; ++k) {
      if(con[i][k] == at0+1) {
        ++snap2;
        con[i][k] = 0;
        break;
      }  /* if */
    }  /* for(k) */
  }  /* for(i) */
  
  /* return 1 for successful outcome; 0 otherwise */
  return((snap1 && snap2) && (snap1 == snap2));

}

int break_bond(int at0, int at1, int ncon, int **con)
{
  int snap1 = 0, snap2 = 0;
  register int k;
  
  for(k=0; k<ncon; ++k) {
    if(con[at0][k] == at1+1) {
      con[at0][k] = 0;
      ++snap1;
      break;
    }  /* if */
  }  /* for(i) */

  for(k=0; k<ncon; ++k) {
    if(con[at1][k] == at0+1) {
      con[at1][k] = 0;
      ++snap2;
      break;
    }  /* if */
  }  /* for(i) */

  /* return 1 for successful outcome; 0 otherwise */
  return(snap1 && snap2);

}




