#include <stdio.h>
#include <stdlib.h>

#include "mmio.h"
#include "definitions.h"
#include "mm_io.h"

#define err() \
 printf( "ERR encountered, file %s, line %d\n", __FILE__, __LINE__ )

int check_mmod(char fname[], int *iread, int con_num, int *na, int *nr,
               char mol_name[])
{
  int status;

  int ct_type_requested = MMIO_FULL;

  /* tell mmio library to write its errmsgs, if any, to stdout: */
  mmio_errfile( stdout );

  status = mmio_open( iread, fname, MMIO_READ );
  if( status == MMIO_ERR ) {
    err();
    exit(8);
  }
  status = mmio_goto_ct( *iread, con_num );
  status = mmio_get_ct( *iread, ct_type_requested, na, mol_name );
  if( status == MMIO_ERR ) {
    return(0);
  }
  if( status == MMIO_EOF ) {
    /* no more structures to be read: */
    return(0);
  }

  if(*na == 0) return(0);

  /* HACK: put number of residues equal to number of atoms */
  *nr = *na;

  return(1);

}
void read_mmod(int iread, int na, int nr, int asy[], int ires[],
               int **con, float **xyz)
{
  /* mmio-specific data */
  char chain, resname1, pdbname[MMIO_S_STRLEN+1];
  char res_pdbn[MMIO_S_STRLEN+1];
  int t_con[MMIO_MAXBOND], t_mul[MMIO_MAXBOND];
  int status;
  int t_res_num, nbond;
  int ct_type_requested = MMIO_FULL;
  float t_xyz[3];
  float q;

  int itmp;
  char my_str[80];

  int idx, id;
  int colour;

  register int i, j;

  for(i=0; i<na; i++) {

    mmio_get_atom( iread, &idx, &id, &nbond, t_con,
                   t_mul, t_xyz, &q, &q,
                   &chain, &colour, &t_res_num, &resname1, res_pdbn,
                   pdbname );

    for(j=0; j<3; ++j) xyz[i][j] = t_xyz[j];

    /* WARNING: here we assume that "nbond" is not larger than the
       maximum connection number */
    for(j=0; j<nbond; ++j) con[i][j] = t_con[j];

    asy[i] = col2sym(id);

    /* assign its first atom to this residue */
    if(ires[t_res_num] == NULL) ires[t_res_num-1] = i+1;

  } /* for(i) */

  status = mmio_close( iread );
  if(status == MMIO_ERR) {
    err();
    exit(8);
  }

}

int col2sym(int id)
{
  if(id>=1  && id<15) return _C_;
  else
  if(id>=15 && id<24) return _O_;
  else
  if(id>=24 && id<41) return _N_;
  else
  if(id>=41 && id<49) return _H_;
  else
  if(id>=49 && id<53) return _S_;
  else
  switch(id) {
    case 53 : return _P_;
    case 56 : return _F_;
    case 57 : return _Cl_;
    case 58 : return _Br_;
    case 59 : return _I_;
    case 63 : return _Lp_;
    default :
      printf("Atom id %d not supported yet!\n", id);
      exit(8);
  }
} /*  col2sym */




