#ifndef _LNKLSTMP_H_
#define _LNKLSTMP_H_

#include "lnklst.h"

// destructor
template <class type>
lnklst<type>::~lnklst() {
  list_node *temp = head;

  while(temp) {
    head->next = temp->next;
    delete temp;
    temp = head->next;
  }
  delete head;
}

// empty list ?
template <class type>
BOOL lnklst<type>::empty() const
{
  return head->next == 0 ? TRUE : FALSE;
}

// insert one element
template <class type>
void lnklst<type>::insert(const type& new_el)
{
	list_node *marker = head;
	
	for(; marker->next; marker = marker->next) {}
    marker->next = new list_node(new_el, marker->next);
}

// delete an element
template <class type>
BOOL lnklst<type>::remove(const type& del_el)
{
  list_node *marker = head, *temp;

  // reach element location or end
  for(; marker->next && marker->next->elem != del_el;
      marker = marker->next) {}
  if((temp = marker->next) && marker->next->elem == del_el) {
    marker->next = marker->next->next;
    // clear memory
    delete temp;
    return TRUE;
  }
  return FALSE;
}

#endif




