#ifndef _LNKLST_H_
#define _LNKLST_H_

/*
   Rowe G.W. "Introduction to Data Structures and Algorithms 
   with C++", Prentice Hall, 1997, p 175
 */

#include "my_bool.h"

template <class type>
class lnklst
{
  protected :
    struct list_node
    {
      type elem;
      list_node *next;
      
      list_node() : next(0) {}
      list_node(type data, list_node *node = 0) :
        elem(data), next(node) {}
    };
 
    list_node *head;
    type null_val;
  public :
    lnklst() : head(new list_node) {}
    lnklst(type nv) : null_val(nv), head(new list_node) {}
    virtual ~lnklst();
    BOOL empty() const;
    virtual void insert(const type& new_el);
    virtual BOOL remove(const type& del_el);
};

#endif




