#ifndef _DATA_TEMPL_H_
#define _DATA_TEMPL_H_

#include "datalist.h"

template <class type>
void datalist<type>::store(const type& in_list, int index)
{
  element[index] = in_list;
}                                               

template <class type>
void datalist<type>::retrieve(type& out_list, int index) const
{
  out_list = element[index];
}                                               

template <class type> ostream& operator<<(ostream &out_str,
                                          const datalist<type> &out_list)
{
	out_str << "Array contents:\n";
	for(int i = 0; i < out_list.array_size; ++i)
		out_str << out_list.element[i] << ' ';
	out_str << "Array size: " << out_list.array_size << endl;
	return out_str;
}

template <class type> istream& operator>>(istream &in_str,
                                          datalist<type> &in_list)
{
	cout << "Enter array elements:\n";
	for(int i = 0; i < in_list.array_size; ++i)
		in_str >> in_list.element[i];
	return in_str;
}

#endif




