#ifndef _COORD_H_
#define _COORD_H_

#include <iostream.h>
#include <math.h>

// This is a class for coordinates
class coord {
  private:
    double XYZ[3];
  public:
    coord(double X = 0, double Y = 0, double Z = 0) {
      XYZ[0] = X;
      XYZ[1] = Y;
      XYZ[2] = Z;
    }
    void assign(double X = 0, double Y = 0, double Z = 0) {
      XYZ[0] = X;
      XYZ[1] = Y;
      XYZ[2] = Z;
    }
		// extract/insert values passing by reference
    double& x() {return XYZ[0];}
    double& y() {return XYZ[1];}
    double& z() {return XYZ[2];}
    double& operator[] (const unsigned int index) {return XYZ[index];}
		// pass pointer
    double* xyz() {return XYZ;}
		// input/output
    friend istream& operator>>(istream& in, coord& a)
    {
      for(int i = 0; i<3; ++i) in >> a.XYZ[i];
      return in;
    };
    friend ostream& operator<<(ostream& out, const coord& a)
    {
      for(int i = 0; i<3; ++i) out << setw(12) << a.XYZ[i];
      return out;
    };
    virtual ~coord() {}
};

#endif




