#ifndef _VWD_RADIA_H_
#define _VWD_RADIA_H_

#include "definitions.h"
#include "atom_class.h"

/*
   van der Waals radii from Amber file
   parm94_96.dat
 */
static const float vdW_Radii_AMBER[] = {
  0.,               /* Lp */
  0.6000,           /* H  */
  0., 0., 0., 0.,
  1.9080,           /* C  */
  1.8240,           /* N  */    
  1.6612,           /* O  */
  1.7500,           /* F  */
  0., 0., 0., 0., 0.,
  2.1000,           /* P  */
  2.0000,           /* S  */
  0.
};

/*
    NCC force field parameters
 */
static const float vdW_Radii_NOVARTIS[] = {
  0.,               /* Lp */
  1.00,             /* H  */
  0., 0., 0., 0.,
  1.65,             /* C  */
  1.55,             /* N  */    
  1.40,             /* O  */
  1.45,             /* F  */
  0., 0., 0., 0., 0.,
  1.90,             /* P  */
  1.80,             /* S  */
  0.
};

/*
    A. Bondi (1964) "van der Waals Volumes and
    Radii" J.Phys.Chem. 68, 441-451. 
 */
static const float vdW_Radii_Bondi[] = {
  0.,               /* Lp */
  1.20,             /* H  */
  0., 0., 0., 0.,
  1.70,             /* C  */
  1.55,             /* N  */    
  1.52,             /* O  */
  1.47,             /* F  */
  0., 0., 0., 0., 0.,
  1.80,             /* P  */
  1.80,             /* S  */
  1.75,             /* Cl */
  0., 0., 0., 0., 0.,
  0., 0., 0., 0., 0.,
  0., 0., 0., 0., 0., 0., 0.,
  1.85,             /* Br */
  0., 0., 0., 0., 0.,
  0., 0., 0., 0., 0.,
  0., 0., 0., 0., 0., 0., 0.,
  1.80,             /* I  */
  0.
};

#define vdW_Radii vdW_Radii_Bondi

class amber_vdw : public atom_hash
{
  public :
    amber_vdw(int size = 100) : atom_hash(size) {
    
    }
};

class amber_eps : public atom_hash
{
  public :
    amber_eps(int size = 100) : atom_hash(size) {
    
    }
};

#endif




