#include <stdlib.h>
#include <stdio.h>

#include "sort.h"

void re_sort(int nlig, int ntot, int plig,
             int mid[], int asy[], int typ[], int hyb[],
             int maxcon, int **con, float **xyz)
/*  To sort the atoms molecule by molecule. Use key-indexed counting
 */
{
  register int i, j, k;
  int ilig, irec;
  int *newid;
  int *xint;
  int **xcon = NULL;
  float **xxyz = NULL;

  xcon = (int **) malloc(ntot*sizeof(int *));
  for(i=0; i<ntot; ++i) xcon[i] = (int *) calloc(maxcon, sizeof(int));
  
  xxyz = (float **) malloc(ntot*sizeof(float *));
  for(i=0; i<ntot; ++i) xxyz[i] = (float *) calloc(3, sizeof(float));

  xint = (int *) calloc(ntot, sizeof(int));

  newid = (int *) calloc(ntot, sizeof(int));
  
  /* put ligand first, all other atoms after it */
  ilig = 0;
  irec = nlig;
  
  /* give a new index to this atom */
  for(i=0; i<ntot; ++i) newid[i] = (mid[i]==plig ? ilig++ : irec++);

  for(i=0; i<ntot; ++i) xint[newid[i]] = mid[i];
  for(i=0; i<ntot; ++i) mid[i] = xint[i];
  for(i=0; i<ntot; ++i) xint[newid[i]] = asy[i];
  for(i=0; i<ntot; ++i) asy[i] = xint[i];
  for(i=0; i<ntot; ++i) xint[newid[i]] = typ[i];
  for(i=0; i<ntot; ++i) typ[i] = xint[i];
  for(i=0; i<ntot; ++i) xint[newid[i]] = hyb[i];
  for(i=0; i<ntot; ++i) hyb[i] = xint[i];

  for(i=0; i<ntot; ++i)
    for(j=0; j<3; ++j) xxyz[newid[i]][j] = xyz[i][j];
  for(i=0; i<ntot; ++i)
    for(j=0; j<3; ++j) xyz[i][j] = xxyz[i][j];

  for(i=0; i<ntot; ++i)
    for(j=0; j<maxcon; ++j) xcon[newid[i]][j] =
      ((k = con[i][j]) != NULL ? newid[k-1] + 1 : 0);
  for(i=0; i<ntot; ++i)
    for(j=0; j<maxcon; ++j) con[i][j] = xcon[i][j];

  free(newid);

  for(i=0; i<ntot; ++i) free(xcon[i]);
  free(xcon);
  for(i=0; i<ntot; ++i) free(xxyz[i]);
  free(xxyz);
  free(xint);

} /*  re_sort */



