#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <string.h>

#include "definitions.h"
#include "io.h"

#define SYBHEAD "@<TRIPOS>MOLECULE"
#define ATHEAD  "@<TRIPOS>ATOM"
#define BNDHEAD "@<TRIPOS>BOND"
#define RESHEAD "@<TRIPOS>SUBSTRUCTURE"

int check_syb(FILE *fp, int *pna, int *pnb, int *prs, char mol_name[])
{
  char string[256];

  while (fgets(string, 256, fp)) {
    if(!strncmp(SYBHEAD, string, strlen(SYBHEAD))) {
      if(!fgets(mol_name, 70, fp)) break;
      if(fscanf(fp, "%d %d %d", pna, pnb, prs) == EOF) break;
      rewind(fp);
      return(1);
    }
  }
  rewind(fp);
  return(0);
} 

void read_syb(FILE *fp, int na, int nb, int nr,
              int asy[], struct bond bonds[], int ires[], float **xyz)
{
  char string[256], word[9];
  int it0, it1;
  register int i;

  while (fgets(string, 256, fp)) {
    if(!strncmp(string, ATHEAD, strlen(ATHEAD))) {
      for(i = 0; i < na; ++i) {
        if(!fgets(string, 256, fp)) {
          printf("Error in SYBYL input file\n");
          exit(1);
        }
        sscanf(string, "%*d%*s%f%f%f%s",
               &xyz[i][0], &xyz[i][1], &xyz[i][2], word);
        /* extract the atomic symbol */
        if(!isalpha(word[1])) word[1] = '\0';
        else
        if(!isalpha(word[2])) word[2] = '\0';
        asy[i] = asy2num(word);
      } /* for(i) */
    } /* if */
    else if(!strncmp(string, BNDHEAD, strlen(BNDHEAD))) {
      for(i = 0; i < nb; ++i) {
        if(!fgets(string, 256, fp)) {
          printf("Error in SYBYL input file\n");
          exit(1);
        }
        sscanf(string, "%*d%d%d%*s", &it0, &it1);
        bonds[i].aa = it0;
        bonds[i].ab = it1;
      } /* for(i) */
    } /* if */
    else if(!strncmp(string, RESHEAD, strlen(RESHEAD))) {
      for(i = 0; i < nr; ++i) {
        if(!fgets(string, 256, fp)) {
          printf("Error in SYBYL input file\n");
          exit(1);
        }
        sscanf(string, "%*d%*s%d", &ires[i]);
      } /* for */
    } /* else */
  } /* while */  
} 

int asy2num(char string[])
{
  if(!strcmp(string, "H")) return _H_;
  else
  if(!strcmp(string, "C")) return _C_;
  else
  if(!strcmp(string, "N")) return _N_;
  else
  if(!strcmp(string, "O")) return _O_;
  else
  if(!strcmp(string, "F")) return _F_;
  else
  if(!strcmp(string, "P")) return _P_;
  else
  if(!strcmp(string, "S")) return _S_;
  else
  if(!strcmp(string, "CL") ||
    !strcmp(string, "Cl")) return _Cl_;
  else
  if(!strcmp(string, "BR") ||
    !strcmp(string, "Br")) return _Br_;
  else
  if(!strcmp(string, "I")) return _I_;
  else
  if(!strcmp(string, "LP") ||
    !strcmp(string, "Lp")) return _Lp_;
  else {
    printf("Atom %s not supported yet\n", string);
    exit (1);
  }
  return 0;
}




