#include <stdlib.h>

#include "definitions.h"
#include "hybr.h"

void get_hyb(int ntot, int asy[], int maxcon, int **con, int flag[])
{
  register int i, j, k;
  int acon;
  int *thio_flag;
  int *ncon;

  thio_flag = (int *) malloc(ntot * sizeof(int));
  ncon = (int *) malloc(ntot * sizeof(int));

  for(i=0; i<ntot; ++i) thio_flag[i] = 0;
  for(i=0; i<ntot; ++i) ncon[i] = 0;
  
  for(i=0; i<ntot; ++i) 
    for(j=0; j<maxcon; ++j) if(con[i][j]) ++ncon[i];

  for(i=0; i<ntot; ++i) {
    acon = ncon[i];
    switch(asy[i]) {
      case _C_ :
        switch(acon) {
          case 2 :
            flag[i] = SP1;
            break;
          case 3 :
            flag[i] = SP2;
            for(j=0; j<maxcon; ++j) {
              if((k=con[i][j]) == NULL) continue;
              --k;
	      if(asy[k] == _S_ && ncon[k] == 1) {
                thio_flag[i] = 1;
                break;
              } /* if */ 
            } /* j */
            break;
          case 4 :
            flag[i] = SP3;
            break;
          default :
            break;
        } /* switch */
        break;
      case _N_ :
        switch(acon) {
          case 1 :
            flag[i] = SP1;
            break;
          case 2 :
            flag[i] = SP2;
            break;
          case 4 :
            flag[i] = SP3;
            break;
          default :
            break;
        } /* switch */
        break;
      case _O_ :
        flag[i] = acon == 1 ? SP2 : SP3;
        break;
      case _P_ :
        flag[i] = SP3;
        break;
      case _S_ :
        switch(acon) {
          case 1 :
            flag[i] = SP2;
            break;
          case 2 :
          case 3 :
          case 4 :
            flag[i] = SP3;
            break;
          default :
            break;
        } /* switch */
        break;
      default :
        break;
    } /* switch */
  } /* i */

  /* look at Nitrogens with three connected atoms */
  for(i=0; i<ntot; ++i) {
    if(asy[i] != _N_) continue;
    if((acon = ncon[i]) != 3) continue;
    flag[i] = SP3;
    for(j=0; j<maxcon; ++j) {
      if((k=con[i][j]) == NULL) continue;
      --k;
      if(asy[k] == _S_) continue;
      if(flag[k] == SP2 && !thio_flag[k]) {
        flag[i] = SP2;
        break;
      } /* if */
    } /* j */
  } /* i */

  free(ncon);
  free(thio_flag);
}




