#include "hbon.h"

void get_hb(int nat, int maxcon, int asy[], int flag[], int **con)
{  
  register int i, j, k;
  int tmp;
  int *ncon = NULL;
  
  ncon = (int *) malloc(nat * sizeof(int));
  
  for(i=0; i<nat; ++i) {
    ncon[i] = 0;
    for(j=0; j<maxcon; ++j) if(con[i][j]) ++ncon[i];
  }
  
  /* terminal atoms only */
  for(i=0; i<nat; ++i) {
    if(ncon[i] > 1) continue;
    j = con[i][0] - 1;
    switch ( asy[i] ) {
      case _H_ :
        if(asy[j] == _O_ || asy[j] == _N_) {
          flag[i] = Donor;
          flag[j] = (asy[j] == _O_ ? Don_Acc : ncon[j] == 2 ? Don_Acc : Accept);
        }
        break;
      case _N_ :
        flag[i] = Accept;
        if(asy[j] == _C_) flag[j] = Polar;
        break;
      case _O_ :
        flag[i] = Accept;
        if(asy[j] == _C_ || asy[j] == _S_) flag[j] = Polar;
        break;
      case _S_ :
        flag[i] = Accept;
        break;
      case _F_ :
        flag[i] = Polar;
        break;
      default :
        break;
    } /* switch */
  } /* for(i) */
  
  /* all atoms except S, C */
  for(i=0; i<nat; ++i) {
    if(ncon[i] == 1) continue;
    if(flag[i]) continue;
    switch ( asy[i] ) {
      case _N_ :
        flag[i] = ncon[i] < 3 ? Accept : Polar;
        break;
      case _O_ :
        flag[i] = Accept;
        break;
      case _P_ :
        flag[i] = Polar;
        break;
      default:
        break;
    } /* switch */
  } /* for(i) */
  
  /* S */
  for(i=0; i<nat; ++i) {
    if(asy[i] != _S_) continue;
    if(flag[i]) continue;
    for(k=0; k<ncon[i]; ++k) {
      j = con[i][k] - 1;
      if(asy[j] == _F_) continue;
      if(asy[j] == _C_) continue;
      if(flag[j] == Accept ||
         flag[j] == Donor ||
         flag[j] == Don_Acc ||
         flag[j] == Polar) {
        flag[i] = Polar;
        break;
      } /* if */
    } /* for(j) */
    if(flag[i] == Polar) {
      /* look for other S-atoms */
      for(k=0; k<ncon[i]; ++k) {
        j = con[i][k] - 1;
        if(asy[j] == _S_ && !flag[j]) flag[j] = Polar;
      } /* for(j) */
    } /* if */
  } /* for(i) */
  
  /* C */
  for(i=0; i<nat; ++i) {
    if(asy[i] != _C_) continue;
    if(flag[i]) continue;
    tmp = 0;
    /* count connected polar atoms */
    for(k=0; k<ncon[i]; ++k) {
      j = con[i][k] - 1;
      if(asy[j] == _F_) continue;
      if(asy[j] == _C_) continue;
      if(flag[j] == Accept ||
         flag[j] == Donor ||
         flag[j] == Don_Acc ||
         flag[j] == Polar) ++tmp;
    } /* for(j) */
    if(tmp > 1) flag[i] = Polar;
  } /* for(i) */
  
  free(ncon);
  
} /* get_hb() */




