#ifndef _HASHTMP_H_
#define _HASHTMP_H_

#include "hash.h"
#include "lnklstmp.h"

// functions for the linked list class
template <class type>
BOOL chain_list<type>::search(const type& item) const
{
  list_node *marker;

  for(marker = head->next; marker && marker->elem != item;
      marker = marker->next) {}
  return marker ? TRUE : FALSE;
}

template <class type>
BOOL chain_list<type>::search(const type& item, type& found) const
{
  list_node *marker;

  for(marker = head->next; marker && marker->elem != item;
      marker = marker->next) {}
  if(marker) {
    found = marker->elem;
    return TRUE;
  }
  found = item;
  return FALSE;
}

// functions for the hash table class
template <class type>
hash_table<type>::hash_table(int size) :
  table_size(size), bucket(new chain_list<type>[size]) {}

template <class type>
hash_table<type>::~hash_table()
{
  delete [] bucket;
}

template <class type>
BOOL hash_table<type>::store(const type& item)
{
  int index = hash_func(item);
  if(bucket[index].search(item)) return FALSE;
  bucket[index].insert(item);
  return TRUE;
}

template <class type>
BOOL hash_table<type>::retrieve(const type& item,
                                type& found) const
{
  int index = hash_func(item);
  return bucket[index].search(item, found) ? TRUE : FALSE;
}

#endif




