#ifndef _HASH_H_
#define _HASH_H_

#include "lnklst.h"

// linked list with search function added
template <class type>
class chain_list : public lnklst<type>
{
  public :
    chain_list() : lnklst<type>() {}
    BOOL search(const type& ele) const;
    BOOL search(const type& ele, type& found) const;
};

template <class type>
class hash_table
{
  protected:
    chain_list<type> *bucket;
    int table_size;
    virtual int hash_func(const type& item) const = 0;
  public:
    hash_table(int size = 1000);
    virtual ~hash_table();
    BOOL store(const type& item);
    BOOL retrieve(const type& item,
      type& found) const;
};

#endif




