#include <stdlib.h>
#include <math.h>

#include "geom.h"

float dsq(int aa, int ab, float **xyz)
/* squared distance */
{
  float f0, f1 = 0.;
  register int i;
  
  for(i=0; i<3; ++i) {
    f0 = xyz[aa][i] - xyz[ab][i];
    f1 += f0*f0;
  }  /* i */
  
  return f1;
}

float ang(int aa, int ab, int ac, float **xyz)
/* angle ABC */
{
  float a2, b2, c2;
  float f0;
  
  a2 = dsq(ab, ac, xyz);
  b2 = dsq(aa, ac, xyz);
  c2 = dsq(aa, ab, xyz);
  
  f0 = a2 + c2 - b2;
  f0 /= 2. * sqrt(a2) * sqrt(c2);
  
  return acos(f0);
}




