/*********************************************************************
 *********************************************************************/

#define ANSI
#undef FULL_CONN
#define MMIO

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#ifndef ANSI
#include <console.h>
#endif

#include "comments.h"
#include "definitions.h"
#include "io.h"
#include "connect.h"
#include "sort.h"
#include "hybr.h"
#include "hbon.h"
#include "scor.h"
#include "msi_io.h"

#ifdef MMIO
#include "mm_io.h"
#endif

/*********************************************************************/

/* GLOBAL DEFINITIONS */

const int Lipo = Non_Polar;

const float OM6 = 1.e-06;
const float OM9 = 1.e-09;

const struct coeff proteus = {
  "Eldridge et al, J. Comput-Aided Mol. Des., 11, 425-445, 1997",
  -5.48,
  -3.34,
  -6.03,
  -0.117,
   0.0,
   2.56
};

/*********************************************************************/

enum ffo {UNDEF_FF, SYBYL, MMOD, CAR};

const int MAXCON = 4;
const int NLIG = 1;

#define USESTR "fresno -r resn -a atn -m mdf_file -H -L -R -J < input"

void do_all(FILE *fp, int argc, char *argv[]);
void energy(struct coeff cf, struct score sc);

int main(int argc, char *argv[])
{

#ifndef ANSI
  argc = ccommand(&argv);
#endif

  do_all(stdin, argc, argv);
  
  return 0;
}

void do_all(FILE *fp, int argc, char *argv[])
{
  struct score score;
  float lj_rep = 0., lj_att = 0., bp_int = 0.;
  int **con = NULL;
  char mystr[80];
  int nres = 1, nat = 0, nmol = 0, nlig = 0, nbnd = 0;
  register int i;
  int *asy, *typ, *hyb, *mcn, *ires;
  
  struct bond *bonds = NULL;
  float **xyz = NULL;

  int lig_ref_res = 0, lig_ref_at = 0, lig_ref_mol = NLIG;
  char *cp0, *cp1;

  int do_hb = 1, do_lip = 1, do_rot = 1, do_lj = 1, do_burp = 1;
  int fil_for = UNDEF_FF;
  int itmp;
#ifdef MMIO
  int mm_iread, con_num = 0;
#endif
  /* MSI stuff */
  char car_fn[80], mdf_fn[80];
  char **asy_str = NULL, **resnum = NULL;
  int **mul = NULL;
  FILE * mdf_fp;
  
  while(argc--) {
    if(*(cp0 = argv[argc]) == '-') {
      cp1 = argv[argc+1];
      switch (*(++cp0)) {
        case 'r' : lig_ref_res = atoi(cp1);
          break;
        case 'a' : lig_ref_at = atoi(cp1);
          break;
#ifdef MMIO
        case 'c' : con_num = atoi(cp1) - 1;
          break;
#endif
        case 'm' : strcpy(mdf_fn, cp1);
          break;
        case 'H' : do_hb = 0;
          break;
        case 'L' : do_lip = 0;
          break;
        case 'R' : do_rot = 0;
          break;
        case 'B' : do_burp = 0;
          break;
        case 'J' : do_lj = 0;
          break;
        default:
          printf(USESTR);
          exit(1);
      }
    } /*  if  */
  } /* while(argc--) */

  if(!lig_ref_res && !lig_ref_at)
    BAILOUT("Enter reference atom or residue number for ligand!");

  /* get number of atoms, bonds, residues */
  if(check_syb(fp, &nat, &nbnd, &nres, mystr)) fil_for = SYBYL;
#ifdef MMIO
  else
  if(check_mmod("-", &mm_iread, con_num, &nat, &nres, mystr)) fil_for = MMOD;
#endif
  else
  if(check_car(fp, &itmp, &nat, mystr)) fil_for = CAR;

  if(fil_for == UNDEF_FF) BAILOUT("Wrong input file\n")

  printf("%s\n\n", mystr);

  printf("%5d\t atoms found\n", nat);

  con = (int **) malloc(nat*sizeof(int *));
  if(!con) BAILOUT("out of memory")
  for(i=0; i<nat; ++i) con[i] = (int *) calloc(MAXCON, sizeof(int));
  
  xyz = (float **) malloc(nat*sizeof(float *));
  if(!xyz) BAILOUT("out of memory")
  for(i=0; i<nat; ++i) xyz[i] = (float *) malloc(3 * sizeof(float));

  ires = (int *) calloc(nres, sizeof(int));
  if(!ires) BAILOUT("out of memory")

  asy = (int *) calloc(nat, sizeof(int));
  if(!asy) BAILOUT("out of memory")
  mcn = (int *) calloc(nat, sizeof(int));
  if(!mcn) BAILOUT("out of memory")
  typ = (int *) calloc(nat, sizeof(int));
  if(!typ) BAILOUT("out of memory")
  hyb = (int *) calloc(nat, sizeof(int));
  if(!hyb) BAILOUT("out of memory")

  switch(fil_for) {
    case SYBYL:
      bonds = (struct bond *) malloc(nbnd*sizeof(struct bond));
      if(!bonds) BAILOUT("out of memory")
      read_syb(fp, nat, nbnd, nres, asy, bonds, ires, xyz);
      bnd2con(nat, nbnd, bonds, MAXCON, con);
      break;
    case MMOD:
#ifdef MMIO
      read_mmod(mm_iread, nat, nres, asy, ires, con, xyz);
      break;
#endif
    case CAR:
      /* set up "mdf" file */
      /* 
      strcpy(mdf_fn, car_fn);
      for(i=strlen(mdf_fn); i>=0; --i) if(mdf_fn[i]=='.') break;
      if(i) mdf_fn[i] = '\0';
      strcat(mdf_fn, ".mdf");
       */
      mdf_fp = fopen(mdf_fn, "r");
      if(!mdf_fp) BAILOUT("cannot open 'mdf' file!")

      /* allocate memory */
      asy_str = (char **) malloc(nat*sizeof(char *));
      if(!asy_str) BAILOUT("out of memory")
      for(i=0; i<nat; ++i) asy_str[i] = (char *) calloc(3, sizeof(char));
      resnum = (char **) malloc(nat*sizeof(char *));
      if(!resnum) BAILOUT("out of memory")
      for(i=0; i<nat; ++i) resnum[i] = (char *) calloc(5, sizeof(char));
      mul = (int **) malloc(nat*sizeof(int *));
      if(!mul) BAILOUT("out of memory")
      for(i=0; i<nat; ++i) mul[i] = (int *) calloc(MAXCON, sizeof(int));

      read_msi(fp, mdf_fp, &itmp, asy_str, resnum, con, mul, xyz);

      /* convert the atom symbols */
      for(i=0; i<nat; ++i) asy[i] = asy2num(asy_str[i]);

      fclose(mdf_fp); 

      /* free memory */
      for(i=0; i<nat; ++i) free( mul[i] );
      for(i=0; i<nat; ++i) free( resnum[i] );
      for(i=0; i<nat; ++i) free( asy_str[i] );
      free(mul); free(resnum); free(asy_str);
      break;
    default:
      BAILOUT("Unknown file type")
      break;
  }

  /* the ligand is this structure */
  if(lig_ref_res) lig_ref_at = ires[lig_ref_res-1];

  if(lig_ref_at > nat) BAILOUT("reference atom/residue outside boundary");

#ifdef FULL_CONN
  nmol = mol_count(nat, MAXCON, con, mcn);

  if(lig_ref_at) lig_ref_mol = mcn[lig_ref_at-1];
  
  printf("%5d\t molecule(s) found\n", nmol);
#else
  nmol = 2;
  
  fast_count(nat, lig_ref_at, MAXCON, con, mcn);
#endif

  /* number of atoms in the ligand */
  for(i=0; i<nat; ++i) if(mcn[i]==lig_ref_mol) ++nlig;

  printf("(%4d\t ligand atoms)\n", nlig);

  /* sort putting the ligand first */
  re_sort(nlig, nat, lig_ref_mol, mcn, asy, typ, hyb,
          MAXCON, con, xyz);

  nbnd = 0;
  /* re-define bonds for the ligand only */        
  bond_list(nlig, MAXCON, con, &nbnd, &bonds);

  /* define H-bond types */
  get_hb(nat, MAXCON, asy, typ, con);

  /* define hybridization */
  get_hyb(nat, asy, MAXCON, con, hyb);

  /* define rotatable bonds (ligand only) */
  get_rot_bond(nlig, hyb, asy, MAXCON, con, nbnd, bonds);

  /* calculate the scores */
  score.hb = do_hb ? hb_score(nlig, nat, typ, con, xyz) : 0.;
  score.lip = do_lip ? lipsco(nlig, nat, typ, asy, xyz) : 0.;
/*
  score.lip = do_lip ? flxlip(nlig, nat, typ, asy, xyz) : 0.;
 */
  score.rot = do_rot ? rotsco(nlig, nat, typ, asy, MAXCON,
                              con, nbnd, bonds, xyz) : 0.;

  /* get the energy expression */
  energy(proteus, score);

  /* Lennard-Jones interaction */
  if(do_lj) lj_int(nlig, nat, asy, xyz, &lj_rep, &lj_att);
  bp_int = do_burp ? burp(nlig, nat, typ, asy, xyz) : 0.;

  printf("\nSpecial:\n");
  printf("\t\tLennard-Jones interaction:\n\t\tTot.\t rep.\tatt.\n");
  printf("\t\t%5.1f\t%5.1f\t%5.1f\n\n",
    k2J(lj_rep-lj_att), k2J(lj_rep), -k2J(lj_att));
  printf("\t\tBuried polar score:\t%5.1f\n\n", bp_int);

  /* free memory */
  for(i=0; i<nat; ++i) free(con[i]);
  free(con);
  for(i=0; i<nat; ++i) free(xyz[i]);
  free(xyz);
  free(bonds);
  free(ires);
  free(mcn);
  free(asy);
  free(typ);
  free(hyb);
}

void energy(struct coeff cf, struct score sc)
{
  float tot, xhb, xlip, xrot;

  xhb = cf.hb*sc.hb;
  xlip = cf.lip*sc.lip;
  xrot = cf.rot*sc.rot;

  tot = cf.intrcpt + xhb + xlip + xrot;

  printf("\tTot.\t HB\tLipo\t  Rot.\n");
  printf("Scores\t\t");
  printf("%5.1f\t%5.1f\t%5.1f\n", sc.hb, sc.lip, sc.rot);
  printf("Energy\t%5.1f\t", tot);
  printf("%5.1f\t%5.1f\t%5.1f\n", xhb, xlip, xrot);
  printf("\nP(Ki)\t%5.1f\n", TOPKI(tot));
}




