#ifndef _DEFINITIONS_H_
#define _DEFINITIONS_H_

#define BAILOUT(str) {printf("%s\n", str); exit(1);}

struct bond {
  int aa;
  int ab;
  int rota;
};

enum ATY {_Lp_, _H_, _C_ = 6, _N_, _O_, _F_, _P_ = 15, _S_,
          _Cl_, _Br_ = 35, _I_ = 53};

enum HBTY {Non_Polar, Polar, Donor, Accept, Don_Acc};

enum HYB {UNK_HYB, SP1, SP2, SP3};
/* -Log(Ki) at 298 K : from kJ/mol */
#define TOPKI(a) (-0.17527961 * (a))

#define TORAD(a) (0.174532925 * (a))
#define TODEG(a) (57.29577951 * (a))

#define k2J(a)         (4.186 * (a))
#define J2k(a)    (0.23889154 * (a))

/* scoring function data */
struct score {
  float hb;
  float mtl;
  float lip;
  float aro;
  float rot;
};

struct coeff {
  char title[80];
  float intrcpt;
  float hb;
  float mtl;
  float lip;
  float aro;
  float rot;
};

extern const int Lipo;

extern const float OM6;
extern const float OM9;

extern const struct coeff proteus;

#endif




