#ifndef _DATALIST_H_
#define _DATALIST_H_

#include <iostream.h>

template <class type>
class datalist
{
  protected :
    type *element;
    int array_size;
  public :
    datalist(int arr_siz = 10) : array_size(arr_siz),
      element(new type[arr_siz]) {}
    virtual ~datalist() {
      delete [] element;
    }
    void store(const type& in_list, int index);
    void retrieve(type& out_list, int index) const;
    friend ostream& operator<<(ostream &out_str, const
      datalist<type> &out_list);
    friend istream& operator>>(istream &in_str,
      datalist<type> &in_list);
};

#endif




