/*
 *
 * protein.h
 * Created: 20081222 Jerome Hert
 *  
 */

#ifndef __PROTEIN__
#define __PROTEIN__

#include <stdlib.h>
#include <stdio.h>
#include "constant.h"
#include "geom3d.h"
#include "bio.h"

/*
 * +--------------------------------------------------------------------------+
 * | STRUCTURES                                                               |
 * +--------------------------------------------------------------------------+
 */

typedef struct t_atom
{
	char		type;
	char		type_long[MAX_ATOM_TYPE_LONG];
	t_point		coord;
} t_atom;

typedef struct t_residue
{
	int			id;
	char		chain;
	char		type;
	char		type_long[MAX_RESIDUE_TYPE_LONG];
	int			size;
	t_atom		*atom;
	int			Ca;
	int			Cb;
	t_point		centerofmass;
} t_residue;

typedef struct t_protein
{
	char		file_protein[MAXCHAR];
	char		file_residues[MAXCHAR];
	int			size;
	char		*name;
	char		*header;
	char		*footer;
	t_residue	*residue;
	t_point		centerofca;
} t_protein;

/*
 * +--------------------------------------------------------------------------+
 * | PROTOTYPES                                                               |
 * +--------------------------------------------------------------------------+
 */

t_protein *protein_initialize(		t_protein	*protein);
t_protein *protein_copy(			t_protein	*to, t_protein *from);
t_protein *protein_copy_ca_cb_cm(	t_protein	*to, t_protein *from);
t_protein *protein_copy_infos(		t_protein	*to, t_protein *from);
t_protein *protein_centerofca(		t_protein	*protein);
t_protein *protein_to_origin(		t_protein	*protein);
t_protein *protein_transform(		t_protein	*protein, t_transfo *transfo);
t_protein *protein_transform_ca_cb_cm(t_protein	*protein, t_transfo *transfo);
int	       protein_prepare(			t_protein	*protein);
int 	   protein_prepare_d3_d4(	t_protein	*protein);
void	   protein_free(			t_protein	*protein);
void	   protein_print(FILE *fh,	t_protein	*protein);

t_residue *residue_initialize(		t_residue	*residue);
t_residue *residue_copy(			t_residue	*to, t_residue *from);
t_residue *residue_copy_ca_cb_cm(	t_residue	*to, t_residue *from);
t_residue *residue_populate(		t_residue	*residue, char *resName, char chainID, int resSeq);
t_residue *residue_centerofmass(	t_residue	*residue);
t_residue *residue_transform(		t_residue	*residue, t_transfo *transfo);
t_residue *residue_transform_ca_cb_cm(t_residue	*residue, t_transfo *transfo);
int	       residue_prepare(			t_residue	*residue);
int	       residue_prepare_d3_d4(	t_residue	*residue);
void	   residue_print(FILE *fh,	t_residue	*residue);
void	   residue_free(			t_residue	*residue);

t_atom *atom_initialize(			t_atom		*atom);
t_atom *atom_copy(					t_atom		*to, t_atom *from);
t_atom *atom_populate(				t_atom		*atom, char *atom_type, double x, double y, double z, char *element);
t_atom *atom_transform(				t_atom		*atom, t_transfo *transfo);
void atom_print(		FILE *fh,	t_atom		*atom);

#endif
