/*
 *
 * maps.h
 * Created: 20090106 Jerome Hert
 *  
 */

#ifndef __MAPS__
#define __MAPS__

#include "constant.h"
#include "geom3d.h"
#include "icosa.h"
#include "score.h"
#include "protein.h"

/*
 * +--------------------------------------------------------------------------+
 * | STRUCTURES                                                               |
 * +--------------------------------------------------------------------------+
 */

typedef int t_fp[FP_SIZE];

/*
 * +--------------------------------------------------------------------------+
 * | PROTOTYPES                                                               |
 * +--------------------------------------------------------------------------+
 */

t_fp *map_initialize(	t_fp	*map);
t_fp *map_copy		(	t_fp	*to,	t_fp		*from);
t_fp *map_compute(		t_fp	*map,	t_protein	*protein);
t_fp *map_compute_fp(	t_fp	*map,	t_protein	*protein);
t_score *map_compare(		t_score *score, t_fp *map1, t_fp *map2, int score_d3);
t_score *map_calculate_d4(	t_score *score, t_fp *map1, t_fp *map2, t_protein *p1, t_protein *p2);
void map_print(			FILE *fh, t_fp	*map);

t_fp *fp_compute_fp(	t_fp	*fp,	t_residue	*residue, t_point *centerofca);
double fp_compare(		t_fp *fp1, t_fp *fp2);

#endif
