/*
 *
 * license.c
 * Created: 20090209 Jerome Hert
 *  
 */

#include "license.h"

/*
 * +--------------------------------------------------------------------------+
 * | Prototypes                                                               |
 * +--------------------------------------------------------------------------+
 */


static void unccrypt( char *to, char *from );
static int find( char *alphabet , int size , char c);

/*
 * +--------------------------------------------------------------------------+
 * | Generic functions                                                        |
 * +--------------------------------------------------------------------------+
 */

int check_license(FILE *fh, char *file_license, int verbosity) {
	int		i;
	int		license_not_valid	= TRUE;
	int		nb_lines			= ZERO;
	char	*home_dir			= NULL;
	FILE	*fh_lic				= NULL;
	int		current_year, current_month, current_day;
	int		expire_year,  expire_month,  expire_day;
	char	line[LICCHAR+TWO];
	char	license[LICCHAR+TWO];
	char	buffer[MAXCHAR];
	char	*string_date;
	time_t	rawtime;
	struct	tm *timeinfo;

	/* Initialize the license */
	for (i=ZERO; i<LICCHAR+TWO; i++)
		license[i] = '\0';

	/*
	 * If license file has not been define as a argument,
	 * use the $HOME/.siteAlign/licence.txt file
	 */
	if (strlen(file_license) == ZERO) {
		home_dir = getenv("HOME");
		if (home_dir == NULL) {
			fprintf(fh, "ERROR:\tCannot find your home directory\n");
			return license_not_valid;
		}
		file_license = strcat( home_dir , "/.siteAlign/licence.txt\0" ); ;
	}

	/* Open license file for reading */
	if ( ( fh_lic = fopen(file_license, "r") ) == NULL ) {
		fprintf(stderr, "ERROR:\tCannot open file %s for reading\n", file_license);
		return license_not_valid;
	}

	/* Read the license in the license file */
	while ( fgets(line, LICCHAR+TWO, fh_lic) != NULL ) {
		nb_lines++;
		sscanf(line,"%s",license);
	}
	fclose(fh_lic);

	/* Various checks! */
	if ( nb_lines != 1 )
		return license_not_valid;

	for ( i=ZERO; i<LICCHAR; i++ )
		if (license[i] == '\0')
			return license_not_valid;

	for ( i=LICCHAR; i<LICCHAR+TWO; i++)
		if (license[i] != '\0')
			return license_not_valid;
		
	/* Get current date */
	current_year = current_month = current_day = QUADNINES;
	time(&rawtime);
	timeinfo = localtime ( &rawtime );
	strftime (buffer, MAXCHAR, "%F", timeinfo);

	/* Get the current year */
	string_date		= substr(buffer, ZERO, FOUR);
	current_year	= atoi( string_date );
	free(string_date);

	/* Get the current month */
	string_date		= substr(buffer, FIVE, TWO);
	current_month	= atoi( string_date );
	free(string_date);

	/* Get the current month */
	string_date		= substr(buffer, EIGHT, TWO);
	current_day		= atoi( string_date );
	free(string_date);

	/* Check current date */
	if ( current_month == QUADNINES || current_day == QUADNINES)
			return license_not_valid;
		
	if (verbosity)
		fprintf(stderr, "WARNING:\tToday's date is %4d/%02d/%02d\n", current_year, current_month, current_day);

	/* Uncrypt expiration date */
	unccrypt(buffer, license);
	if (strlen(buffer) != TEN)
		return license_not_valid;

	expire_year = expire_month = expire_day = QUADNINES;

	/* Get the expire year */
	string_date		= substr(buffer, ZERO, FOUR);
	expire_year	= atoi( string_date );
	free(string_date);

	/* Get the expire month */
	string_date		= substr(buffer, FIVE, TWO);
	expire_month	= atoi( string_date );
	free(string_date);

	/* Get the expire month */
	string_date		= substr(buffer, EIGHT, TWO);
	expire_day		= atoi( string_date );
	free(string_date);

	/* Check the expire date */
	if ( expire_month == QUADNINES || expire_day == QUADNINES)
			return license_not_valid;
	
	if (verbosity)
		fprintf(stderr, "WARNING:\tLicense expires on %4d/%02d/%02d\n", expire_year, expire_month, expire_day);

	/* Let it run if current date < expire date */
	if (current_year < expire_year)
		license_not_valid = FALSE;
	else if (current_year == expire_year && current_month < expire_month)
		license_not_valid = FALSE;
	else if (current_year == expire_year && current_month == expire_month && current_day <= expire_day)
		license_not_valid = FALSE;

	return license_not_valid;
}

static void unccrypt(char *to , char *from) {
	int size		= 66 ;
	char alphabet[] = { 'a','b','c','d','e','f','g','h','i','j','k','l','m','n','o','p','q','r','s','t','u','v','w','x','y','z','A','B','C','D','E','F','G','H','I','J','K','L','M','N','O','P','Q','R','S','T','U','V','W','X','Y','Z','-','(',')','_','0','1','2','3','4','5','6','7','8','9' } ;
	int indexD		= find( alphabet, 66, from[20] ) ;
	int indexDD		= find( alphabet, 66, from[21] ) ;
	int indexM		= find( alphabet, 66, from[23] ) ;
	int indexMM 	= find( alphabet, 66, from[24] ) ;
	int indexY		= find( alphabet, 66, from[26] ) ;
	int indexYY		= find( alphabet, 66, from[27] ) ;
	int indexYYY	= find( alphabet, 66, from[28] ) ;
	int indexYYYY	= find( alphabet, 66, from[29] ) ;
	if ( indexD+10 >= size || indexDD+33 >= size || indexD+10<0 || indexDD+33<0)
		return;

	/* Get the year */
	to[ZERO]	= '\0';
	if ( indexY+2 >= size || indexYY+15 >= size || indexYYY+27 >= size || indexYYYY+29 >= size)
		return;
	to[ZERO]	= alphabet[ indexY  + 2  ] ;
	to[ONE]		= alphabet[ indexYY + 15 ] ;
	to[TWO]		= alphabet[ indexYYY  + 27 ] ;
	to[THREE]	= alphabet[ indexYYYY + 29 ] ;
	to[FOUR]	= '-';

	/* Get the month*/
	to[FIVE]	='\0';
	if ( indexM+28 >= size || indexMM+10 >= size || indexM+28 < 0 || indexMM+10 < 0 )
		return;
	to[FIVE]    = alphabet[ indexM  + 28 ];
	to[SIX]		= alphabet[ indexMM + 10 ];
	to[SEVEN]	= '-';

	/* Get the day */
	to[EIGHT]	='\0';
	if ( indexD+10 >= size || indexDD+33 >= size || indexD+10 < 0 || indexDD+33 < 0)
		return;
	to[EIGHT]	= alphabet[ indexD  + 10 ] ;
	to[NINE]	= alphabet[ indexDD + 33 ] ;
	to[TEN]		= '\0';
	return;
}

static int find( char *alphabet , int size , char c) {
	int i;
	for ( i=0; i<size; i++) {
      if ( alphabet[i] == c )
	    return i;
   }
   return MINUSONE ;
}
