/*
 *
 * geom3d.h
 * Created: 20081223 Jerome Hert
 *  
 */
 
#ifndef __GEOM3D__
#define __GEOM3D__

#include <stdio.h>
#include <math.h>
#include "constant.h"
/*
 * +--------------------------------------------------------------------------+
 * | STRUCTURES                                                               |
 * +--------------------------------------------------------------------------+
 */

typedef struct t_point {
	double	x;
	double	y;
	double	z;
} t_point;

typedef struct t_angle {
	double	alpha;
	double	beta;
	double	gamma;
} t_angle;

typedef struct t_transfo {
	t_point	translation;
	t_angle	rotation_angle;
	t_angle cos;
	t_angle sin;
} t_transfo;

typedef struct t_explore {
 	int 	rotation_nb;
 	int		translation_nb;
 	double	rotation_int;
 	double	translation_int;
 	double	rotation_increment;
 	double	translation_increment;
} t_explore;

/*
 * +--------------------------------------------------------------------------+
 * | PROTOTYPES                                                               |
 * +--------------------------------------------------------------------------+
 */

double	square(					double x);
double	point_distance( 		t_point *A, t_point *B);
double	point_distance_origin(	t_point *A);
int		distance_discretize(	double x);
int		isRightFrom(			t_point *A, t_point *B, t_point *X);

t_point		*point_initialize(	t_point *point);
t_point		*point_set(			t_point *point, double x, double y, double z);
t_point		*point_copy(		t_point *to, t_point *from);
t_point		*point_translate(	t_point *point_translated, t_point *point, t_point *vector);
t_point		*point_transform(	t_point *point, t_transfo *transfo);
//t_point		*point_rotate(		t_point *point, t_transfo *transfo);
void		point_print(		FILE *fh, t_point *point);

t_angle		*angle_initialize(	t_angle *angle);
t_angle		*angle_set(			t_angle *angle, double alpha, double beta, double gamma);
t_angle		*angle_copy(		t_angle *to, t_angle *from);
void		angle_print(		FILE *fh, t_angle *angle);

t_transfo	*transfo_initialize(t_transfo *transfo);
t_transfo	*transfo_set(		t_transfo *transfo, t_angle rotation_angle, t_point translation);
t_transfo	*transfo_copy(		t_transfo *to, t_transfo *from);
//int			transfo_same_zone(	t_transfo *transfo1, t_transfo *transfo2);
void		transfo_print(		FILE *fh, t_transfo *transfo);

t_explore	*explore_initialize(t_explore *explore);
t_explore	*explore_set(		t_explore *explore, int nrot, int ntrans, double irot, double itrans);
t_explore	*explore_set_nrot(	t_explore *explore, int nrot);
t_explore	*explore_set_ntrans(t_explore *explore, int ntrans);
t_explore	*explore_set_irot(	t_explore *explore, double irot);
t_explore	*explore_set_itrans(t_explore *explore, double itrans);
t_explore	*explore_copy(t_explore *to, t_explore *from);
t_explore	*explore_calculate_refinement(t_explore *explore);
void		explore_print(		FILE *fh, t_explore *explore);

#endif
