/*
 *
 * bio.c
 * Created: 20090105 Jerome Hert Based on bio.c from SiteAlign-3.6
 *  
 */

#include "bio.h"

/*
 * 1-letter code  3-letter code  Amino acid								Rotamer Specific side chain atom
 * A              Ala            alanine								CB
 * B              Asx            either asparagine or aspartic acid		CG
 * C              Cys            cysteine								SG
 * D              Asp            aspartic acid							CG
 * E              Glu            glutamic acid							CD
 * F              Phe            phenylalanine							CZ
 * G              Gly            glycine								CA
 * H              His            histidine								CE1
 * I              Ile            isoleucine								CD1
 * K              Lys            lysine									NZ
 * L              Leu            leucine								CG
 * M              Met            methionine								CE
 * N              Asn            asparagine								CG
 * P              Pro            proline								CG
 * Q              Gln            glutamine								CD
 * R              Arg            arginine								CZ
 * S              Ser            serine									OG
 * T              Thr            threonine								OG1
 * V              Val            valine									CB
 * W              Trp            tryptophan								NE1
 * X              Xxx            undetermined amino acid				CB
 * Y              Tyr            tyrosine								OH
 * Z              Glx            either glutamic acid or glutamine		CD
 */

char aa_short(char *aa_long) {
	if ( strcmp( aa_long,"ALA" ) == 0 ) return 'A';
	/*if ( strncmp( aa_long,"ASX" ) == 0 ) return 'B';*/
	if ( strcmp( aa_long,"CYS" ) == 0 ) return 'C';
	if ( strcmp( aa_long,"ASP" ) == 0 ) return 'D';
	if ( strcmp( aa_long,"GLU" ) == 0 ) return 'E';
	if ( strcmp( aa_long,"PHE" ) == 0 ) return 'F';
	if ( strcmp( aa_long,"GLY" ) == 0 ) return 'G';
	if ( strcmp( aa_long,"HIS" ) == 0 ) return 'H';
	if ( strcmp( aa_long,"ILE" ) == 0 ) return 'I';
	if ( strcmp( aa_long,"LYS" ) == 0 ) return 'K';
	if ( strcmp( aa_long,"LEU" ) == 0 ) return 'L';
	if ( strcmp( aa_long,"MET" ) == 0 ) return 'M';
	if ( strcmp( aa_long,"ASN" ) == 0 ) return 'N';
	if ( strcmp( aa_long,"PRO" ) == 0 ) return 'P';
	if ( strcmp( aa_long,"GLN" ) == 0 ) return 'Q';
	if ( strcmp( aa_long,"ARG" ) == 0 ) return 'R';
	if ( strcmp( aa_long,"SER" ) == 0 ) return 'S';
	if ( strcmp( aa_long,"THR" ) == 0 ) return 'T';
	if ( strcmp( aa_long,"VAL" ) == 0 ) return 'V';
	if ( strcmp( aa_long,"TRP" ) == 0 ) return 'W';
	/*if ( strcmp( aa_long,"XXX" ) == 0 ) return 'X';*/
	if ( strcmp( aa_long,"TYR" ) == 0 ) return 'Y';
	/*if ( strcmp( aa_long,"GLX" ) == 0 ) return 'Z';*/
	/* buggy */
	if ( strcmp( aa_long,"HID" ) == 0 ) return 'H'; /* also Histidine */
	if ( strcmp( aa_long,"HIE" ) == 0 ) return 'H'; /* also Histidine */	/*created the 06/10/17*/
	if ( strcmp( aa_long,"HIP" ) == 0 ) return 'J'; /* Protonated Histidine */	/*created the 06/10/17*/
	
	fprintf(stderr, "WARNING:\tDon't know how to treat residue \"%s\". Only "
					"ALA CYS ASP GLU PHE GLY HIS ILE LYS LEU MET ASN "
					"PRO GLN ARG SER THR VAL TRP TYR HID HIE HIP "
					"are valid. Residue will be ignored.\n", aa_long);
	return '?';
}

char *aa_rot_spe_side_chain_atom(char aa_short) {
	int size;
	char *rot_spe_side_chain_atom, tmp_atom[THREE];
	switch (aa_short) {
		case 'B':
			size = TWO;
			strncpy(tmp_atom, "CG", size);
			break;
		case 'C':
			size = TWO;
			strncpy(tmp_atom, "SG", size);
			break;
		case 'D':
			size = TWO;
			strncpy(tmp_atom, "CG", size);
			break;
		case 'E':
			size = TWO;
			strncpy(tmp_atom, "CD", size);
			break;
		case 'F':
			size = TWO;
			strncpy(tmp_atom, "CZ", size);
			break;
		case 'G':
			size = TWO;
			strncpy(tmp_atom, "CA", size);
			break;
		case 'H':
			size = THREE;
			strncpy(tmp_atom, "CE1", size);
			break;
		case 'I':
			size = THREE;
			strncpy(tmp_atom, "CD1", size);
			break;
		case 'K':
			size = TWO;
			strncpy(tmp_atom, "NZ", size);
			break;
		case 'L':
			size = TWO;
			strncpy(tmp_atom, "CG", size);
			break;
		case 'M':
			size = TWO;
			strncpy(tmp_atom, "CE", size);
			break;
		case 'N':
			size = TWO;
			strncpy(tmp_atom, "CG", size);
			break;
		case 'P':
			size = TWO;
			strncpy(tmp_atom, "CG", size);
			break;
		case 'Q':
			size = TWO;
			strncpy(tmp_atom, "CD", size);
			break;
		case 'R':
			size = TWO;
			strncpy(tmp_atom, "CZ", size);
			break;
		case 'S':
			size = TWO;
			strncpy(tmp_atom, "OG", size);
			break;
		case 'T':
			size = THREE;
			strncpy(tmp_atom, "OG1", size);
			break;
		case 'W':
			size = THREE;
			strncpy(tmp_atom, "NE1", size);
			break;
		case 'Y':
			size = TWO;
			strncpy(tmp_atom, "OH", size);
			break;
		case 'Z':
			size = TWO;
			strncpy(tmp_atom, "CD", size);
			break;
		default:
			size = TWO;
			strncpy(tmp_atom, "CB", size);
	}
	rot_spe_side_chain_atom = (char *)calloc(size + ONE, sizeof(char));
	strncpy(rot_spe_side_chain_atom, tmp_atom, size);
	rot_spe_side_chain_atom[size+ONE] = '\0';
	return rot_spe_side_chain_atom;
}
