/*
 *
 * align.h
 * Created: 20090106 Jerome Hert
 *  
 */

#ifndef __ALIGN__
#define __ALIGN__

#include "constant.h"
#include "geom3d.h"
#include "maps.h"
#include "score.h"

/*
 * +--------------------------------------------------------------------------+
 * | STRUCTURES                                                               |
 * +--------------------------------------------------------------------------+
 */

typedef struct t_alignment {
	t_transfo	transfo;
	t_fp		map[ICOSA_NUM_TRIANGLES];
	t_score		score;
} t_alignment;

/*
 * +--------------------------------------------------------------------------+
 * | PROTOTYPES                                                               |
 * +--------------------------------------------------------------------------+
 */

t_alignment *alignment_initialize(	t_alignment *alignment);
t_alignment *alignment_copy(		t_alignment *to,		t_alignment *from);
t_alignment *align(					t_protein	*p_query,	t_protein	*p_target, t_alignment *alignment_query, t_alignment *alignment_target, t_explore *explore_params, int nb_passes, int verbosity);
t_alignment *calculate_d3_d4(		t_protein	*p_query,	t_protein	*p_target, t_alignment *alignment_query, t_alignment *alignment_target);
t_alignment *align_n_passes(		t_fp		*map, 		t_protein *protein, t_alignment *alignments, t_explore *explore_params, int nb_passes);
t_alignment *align_optimize(		t_fp		*map,		t_protein *protein, t_alignment *alignment, t_explore *explore_params);
t_alignment *keep_best_alignement(	t_alignment *alignments, t_alignment *alignment_current, int nb_passes);
int alignment_get_index_best(		t_alignment *alignments, int size);

#endif
