class Mol2:
	def __init__(self, name_, molecule_, atoms_, bonds_, substructures_):
		self.name = name_
		self.molecule = molecule_
		self.atoms = atoms_
		self.bonds = bonds_
		self.substructures = substructures_

	def set_name(self, name_):
		self.name = name_

	def add_atom(self, atom_):
		self.atoms.append(atom_)

	def add_bond(self, bond_):
		self.bonds.append(bond_)

	def build(self):
		string_molecule = '@<TRIPOS>MOLECULE\n'
		string_molecule += self.molecule.build()
		string_atoms = '@<TRIPOS>ATOM\n'
		for atom in self.atoms:
			string_atoms += '{}\n'.format(atom.build())
		string_bonds = '@<TRIPOS>BOND\n'
		for bond in self.bonds:
			string_bonds += '{}\n'.format(bond.build())
		string_substructures = '@<TRIPOS>SUBSTRUCTURE\n'
		for substructure in self.substructures:
			string_substructures += '{}\n'.format(substructure.build())

		return '{}{}{}{}'.format(string_molecule, string_atoms, string_bonds, string_substructures)

	def get_coord_from_atom_id(self, id_atom_):
		x = self.atoms[int(id_atom_) - 1].x
		y = self.atoms[int(id_atom_) - 1].y
		z = self.atoms[int(id_atom_) - 1].z
		return [x, y, z]

	def get_center_of_mass(self):
		n_atoms = len(self.atoms)
		x_cmass = 0
		y_cmass = 0
		z_cmass = 0
		for atom in self.atoms:
			x_cmass += atom.x
			y_cmass += atom.y
			z_cmass += atom.z

		return [x_cmass/n_atoms, y_cmass/n_atoms, z_cmass/n_atoms]

	def get_neighbors_id_from_atom_id(self, id_atom_):
		list_neighbors = []
		for bond in self.bonds:
			if bond.id_atom1 == int(id_atom_):
				list_neighbors += [bond.id_atom2]
			elif bond.id_atom2 == int(id_atom_):
				list_neighbors += [bond.id_atom1]
		return list_neighbors

	def get_neighbors_bond_type_from_atom_id(self, id_atom_):
		list_neighbors_bond_type = []
		for bond in self.bonds:
			if bond.id_atom1 == int(id_atom_):
				list_neighbors_bond_type.append(bond.type_bond)
			elif bond.id_atom2 == int(id_atom_):
				list_neighbors_bond_type.append(bond.type_bond)
		return list_neighbors_bond_type

	def get_coord_atoms(self, xtract_list_atoms_ = False, xtract_H = True, forbidden_atom_ids_ = []):
		list_coord_atoms = []
		for atom in self.atoms:
			if not atom.id_atom in forbidden_atom_ids_:
				if xtract_list_atoms_ == False:
					list_coord_atoms += [[atom.x, atom.y, atom.z]]
				else:
					list_coord_atoms += [[atom.x, atom.y, atom.z, atom.type_atom]]
		return list_coord_atoms

	def get_coord_heavy_atoms(self, xtract_list_atoms_ = False, forbidden_atom_ids_ = []):
		list_coord_atoms = []
		for atom in self.atoms:
			if not atom.id_atom in forbidden_atom_ids_ and atom.type_atom != "H":
				if xtract_list_atoms_ == False:
					list_coord_atoms += [[atom.x, atom.y, atom.z]]
				else:
					list_coord_atoms += [[atom.x, atom.y, atom.z, atom.type_atom]]
		return list_coord_atoms

class Molecule:
	def __init__(self, name_, n_atoms_, n_bonds_, n_substructure_, mol_type_, charge_type_):
		self.name = name_
		self.n_atoms = str(n_atoms_)
		self.n_bonds = str(n_bonds_)
		self.n_substructure = str(n_substructure_)
		self.mol_type = mol_type_
		self.charge_type = charge_type_

	def build(self):
		string_molecule = '{}\n  {}   {}   {}   {}   {}\n{}\n{}\n'.format(self.name, 
																self.n_atoms, self.n_bonds, self.n_substructure, "0", "0",
																self.mol_type,
																self.charge_type)

		return string_molecule

class Atom:


	def __init__(self, id_atom_, name_, x_, y_, z_, type_atom_, id_sub_, name_sub_, charge_):
		self.id_atom = int(id_atom_)
		self.name = name_
		self.x = float(x_)
		self.y = float(y_)
		self.z = float(z_)
		self.type_atom = type_atom_
		self.id_sub = int(id_sub_)
		self.name_sub = name_sub_
		self.charge = float(charge_)

	def build(self):
		string_atom = '{:6d} {:6} {:10.4f} {:10.4f} {:10.4f} {:6} {:5d} {:8} {:10.4f}'.format(self.id_atom, self.name, 
																								self.x, self.y, self.z,
																								self.type_atom,
																								self.id_sub, self.name_sub,
																								self.charge)
		return string_atom

	def set_id_atom(self, new_id_atom_):
		self.id_atom = int(new_id_atom_)

	def set_name(self, new_name_):
		self.name = str(new_name_)

	def set_name(self, new_x_):
		self.x = float(new_x_)

	def set_name(self, new_y_):
		self.y = float(new_y_)

	def set_name(self, new_z_):
		self.z = float(new_z_)

	def set_type_atom(self, new_type_atom_):
		self.type_atom = str(new_type_atom_)

	def set_id_sub(self, new_id_sub_):
		self.id_sub = int(new_id_sub_)
	
	def set_name_sub(self, new_name_sub_):
		self.name_sub = str(new_name_sub_)

	def set_charge(self, new_charge_):
		self.charge = float(new_charge_)

class Bond:
	def __init__(self, id_bond_, id_atom1_, id_atom2_, type_bond_):
		self.id_bond = int(id_bond_)
		self.id_atom1 = int(id_atom1_)
		self.id_atom2 = int(id_atom2_)
		self.type_bond = type_bond_

	def build(self):
		string_bond = '{:6d} {:6d} {:6d} {}'.format(self.id_bond, self.id_atom1, self.id_atom2, self.type_bond)
		return string_bond

	def set_id_bond(self, new_id_bond_):
		self.id_bond = int(new_id_bond_)

	def set_id_atom1(self, new_id_atom1_):
		self.id_atom1 = int(new_id_atom1_)

	def set_id_atom2(self, new_id_atom2_):
		self.id_atom2 = int(new_id_atom2_)

	def set_type_bond(self, new_type_bond_):
		self.type_bond = new_type_bond_

class Substructure:
	def __init__(self, id_sub_, name_sub_, id_root_):
		self.id_sub = id_sub_
		self.name_sub = name_sub_
		self.id_root = id_root_

	def build(self):
		string_substructure = '{:6d} {:8} {:6d}'.format(int(self.id_sub), self.name_sub, int(self.id_root))
		return string_substructure

class Loader:
	def load_mol2(path_mol2_, multi_mol2_ = False, str_from_multi_mol2_ = ""):

		def cut_mol2(string_mol2_, string_section_):
			section_temp = string_mol2_[string_mol2_.find(string_section_)+len(string_section_):]
			section = section_temp[:section_temp.find("@")]
			return section

		def extract_molecule(string_molecule_):
			compteur = 1

			line_molecule = string_molecule_.split("\n")
			for line in line_molecule:
				if line != "":
					if compteur == 1:
						name = line
						compteur += 1
					elif compteur == 2:
						n_atoms, n_bonds, n_substructure, *r = line.split()
						compteur += 1
					elif compteur == 3:
						mol_type = line
						compteur += 1
					elif compteur == 4:
						charge_type = line

			molecule = Molecule(name, n_atoms, n_bonds, n_substructure, mol_type, charge_type)

			return molecule

		def extract_atoms(string_atom_):
			atoms = []

			line_atoms = string_atom_.split("\n")
			for line in line_atoms:
				if line != "":
					id_atom, name, x, y, z, type_atom, id_sub, name_sub, charge, *r = line.split()
					atom = Atom(id_atom, name, x, y, z, type_atom, id_sub, name_sub, charge)
					atoms += [atom]

			return atoms

		def extract_bonds(string_bond_):
			bonds = []

			line_bonds = string_bond_.split("\n")
			for line in line_bonds:
				if line != "" and line.find("#") == -1:
					id_bond, id_atom1, id_atom2, type_bond, *r = line.split()
					bond = Bond(id_bond, id_atom1, id_atom2, type_bond)
					bonds += [bond]

			return bonds

		def extract_substructures(string_substructure_):
			substructures = []

			line_bonds = string_substructure_.split("\n")
			for line in line_bonds:
				if line != "":
					id_sub, name_sub, id_root, *r = line.split()
					substructure = Substructure(id_sub, name_sub, id_root)
					substructures += [substructure]

			return substructures

		if multi_mol2_ == False:
			with open(path_mol2_, 'r') as file_mol2_hdl:
				string_mol2 = file_mol2_hdl.read()
		else:
			string_mol2 = str_from_multi_mol2_

		string_molecule = cut_mol2(string_mol2, "@<TRIPOS>MOLECULE")
		molecule = extract_molecule(string_molecule)

		string_atom = cut_mol2(string_mol2, "@<TRIPOS>ATOM")
		atoms = extract_atoms(string_atom)

		string_bond = cut_mol2(string_mol2, "@<TRIPOS>BOND")
		bonds = extract_bonds(string_bond)

		if string_mol2.find("@<TRIPOS>SUBSTRUCTURE") != -1:
			string_substructure = cut_mol2(string_mol2, "@<TRIPOS>SUBSTRUCTURE")
			substructures = extract_substructures(string_substructure)
		else:
			substructures = []

		name_mol2 = path_mol2_.split("/")[len(path_mol2_.split("/")) - 1]

		mol2 = Mol2(name_mol2, molecule, atoms, bonds, substructures)

		return mol2

	def load_multi_mol2(path_multi_mol2_):
		with open(path_multi_mol2_, 'r') as file_multi_mol2_hdl:
			string_multi_mol2 = file_multi_mol2_hdl.read()

		multi_mol2_str = string_multi_mol2.split("@<TRIPOS>MOLECULE")[1:]
		multi_mol2 = []
		for mol2_str in multi_mol2_str:
			multi_mol2.append(Loader.load_mol2(path_multi_mol2_, True, '@<TRIPOS>MOLECULE{}'.format(mol2_str)))
		return multi_mol2

class Merger:

	def merge_mol2(dico_information_mol2_, connexion_rules_, new_name_):

		"""
			atoms_connectable : [(1,X), (2,Y), "am"]
			mean :  molecule1, atom X with molecule2, atom Y "amide" bond
		"""

		def get_atoms_and_bonds_to_merge(mol2_, atoms_to_delete_, atoms_to_modify_, bonds_to_modify_, id_atom_starting_point_, id_bond_starting_point_, id_sub_):

			modified_atoms = []
			modified_bonds = []

			table_old_new_id_atom = {}
			count_delete_atom = 0
			for atom in mol2_.atoms:
				if atom.id_atom in atoms_to_delete_:
					count_delete_atom += 1
				else:
					if atom.id_atom in atoms_to_modify_:
						new_atom_type = atoms_to_modify_[atom.id_atom]
						atom.set_type_atom(new_atom_type)
						atom.set_charge(0.0000)

					old_id_atom = atom.id_atom
					new_id_atom = int(atom.id_atom) - count_delete_atom + id_atom_starting_point_
					table_old_new_id_atom[old_id_atom] = new_id_atom
					atom.set_id_atom(new_id_atom)

					atom.set_id_sub(id_sub_)
					atom.set_name_sub('BB{}'.format(id_sub_))
					modified_atoms.append(atom)

			count_delete_bound = 0
			for bond in mol2_.bonds:
				if bond.id_atom1 in atoms_to_delete_ or bond.id_atom2 in atoms_to_delete_:
					count_delete_bound += 1
				else:
					if (bond.id_atom1, bond.id_atom2) in bonds_to_modify_:
						bond.set_type_bond(bonds_to_modify_[(bond.id_atom1, bond.id_atom2)])
					elif (bond.id_atom2, bond.id_atom1) in bonds_to_modify_:
						bond.set_type_bond(bonds_to_modify_[(bond.id_atom2, bond.id_atom1)])

					bond.set_id_atom1(table_old_new_id_atom[bond.id_atom1])
					bond.set_id_atom2(table_old_new_id_atom[bond.id_atom2])

					bond.set_id_bond(bond.id_bond - count_delete_bound + id_bond_starting_point_)
					modified_bonds.append(bond)

			return modified_atoms, modified_bonds, table_old_new_id_atom, count_delete_atom, count_delete_bound

		new_atoms = []
		new_bonds = []
		new_substructures = []

		dico_table_old_new_id_atom = {}
		id_atom_starting_point = 0
		id_bond_starting_point = 0
		for key, information in dico_information_mol2_.items():
			mol2, atoms_to_delete, atoms_to_modify, bonds_to_modify = information
			modified_atoms, modified_bonds, table_old_new_id_atom, count_delete_atom, count_delete_bound = get_atoms_and_bonds_to_merge(mol2, atoms_to_delete, atoms_to_modify, bonds_to_modify, 
																																			id_atom_starting_point, id_bond_starting_point, key)
			id_atom_starting_point += len(modified_atoms)
			id_bond_starting_point += len(modified_bonds)
			new_atoms.extend(modified_atoms)
			new_bonds.extend(modified_bonds)
			dico_table_old_new_id_atom[key] = table_old_new_id_atom

		for rules in connexion_rules_:
			key1, id_atom_connectable_1 = rules[0]
			key2, id_atom_connectable_2 = rules[1]
			type_bond_connexion = rules[2]
			table_old_new_id_atom_key1 = dico_table_old_new_id_atom[key1] # We get the tag connexion table corresping to the mol2 key
			table_old_new_id_atom_key2 = dico_table_old_new_id_atom[key2]

			new_id_atom_connectable_1 = table_old_new_id_atom_key1[id_atom_connectable_1]
			new_id_atom_connectable_2 = table_old_new_id_atom_key2[id_atom_connectable_2]
			id_bond_connexion = len(new_bonds) + 1

			connexion_bond = Bond(id_bond_connexion, new_id_atom_connectable_1, new_id_atom_connectable_2, type_bond_connexion)
			new_bonds.append(connexion_bond)

		# We add last key and id atoms connectable, to avoid dupplicate substructure
		new_substructures.append(Substructure(key1, 'BB{}'.format(key1), new_id_atom_connectable_1))
		new_substructures.append(Substructure(key2, 'BB{}'.format(key2), new_id_atom_connectable_2))


		molecule = Molecule(new_name_, len(new_atoms), len(new_bonds), len(new_substructures), "SMALL", "USER_CHARGES")
		merged_mol2 = Mol2(new_name_, molecule, new_atoms, new_bonds, new_substructures)
		return merged_mol2	

class Builder:
	def add_H(mol2_, coord_H_, id_attached_atom_):

		x_H, y_H, z_H = coord_H_

		attached_atom = mol2_.atoms[int(id_attached_atom_) - 1]

		id_H = str(len(mol2_.atoms) + 1)
		H = Atom(id_H, "Had", x_H, y_H, z_H, "H", attached_atom.id_sub, attached_atom.name_sub, "0.0000")
		bond_H = Bond(len(mol2_.bonds) + 1,  id_H, id_attached_atom_, "1")
		mol2_.add_atom(H)
		mol2_.add_bond(bond_H)
		return mol2_


	def add_triazole_linker(mol2_, id_attached_atom1_, id_attached_atom2_):
		pass



class Geometrics:

	def dot_matrix_3x3(matrix1_, matrix2_):
		
		"""
			[[a, b, c],
			[d, e, f],
			[g, h, i]]
		"""

		a1 = matrix1_[0][0]
		b1 = matrix1_[0][1]
		c1 = matrix1_[0][2]

		d1 = matrix1_[1][0]
		e1 = matrix1_[1][1]
		f1 = matrix1_[1][2]

		g1 = matrix1_[2][0]
		h1 = matrix1_[2][1]
		i1 = matrix1_[2][2]

		a2 = matrix2_[0][0]
		b2 = matrix2_[0][1]
		c2 = matrix2_[0][2]

		d2 = matrix2_[1][0]
		e2 = matrix2_[1][1]
		f2 = matrix2_[1][2]

		g2 = matrix2_[2][0]
		h2 = matrix2_[2][1]
		i2 = matrix2_[2][2]

		new_a = a1 * a2 + a1 * d2 + a1 * g2
		new_b = a1 * b2 + a1 * e2 + a1 * h2
		new_c = a1 * c2 + a1 * f2 + a1 * i2

		new_d = d1 * a2 + d1 * d2 + d1 * g2
		new_e = d1 * b2 + d1 * e2 + d1 * h2
		new_f = d1 * c2 + d1 * f2 + d1 * i2

		new_g = g1 * a2 + g1 * d2 + g1 * g2
		new_h = g1 * b2 + g1 * e2 + g1 * h2
		new_i = g1 * c2 + g1 * f2 + g1 * i2

		dot_matrix = [[new_a, new_b, new_c],
					  [new_d, new_e, new_f],
					  [new_g, new_h, new_i]]

		return dot_matrix

	def dot_matrix_3x1(matrix1_, matrix2_):
		"""
			[[a, b, c],
			[d, e, f],
			[g, h, i]]
		"""
		a1 = matrix1_[0][0]
		b1 = matrix1_[0][1]
		c1 = matrix1_[0][2]

		d1 = matrix1_[1][0]
		e1 = matrix1_[1][1]
		f1 = matrix1_[1][2]

		g1 = matrix1_[2][0]
		h1 = matrix1_[2][1]
		i1 = matrix1_[2][2]

		a2 = matrix2_[0]
		d2 = matrix2_[1]
		g2 = matrix2_[2]

		new_a = a1 * a2 + a1 * d2 + a1 * g2
		new_d = a1 * b2 + a1 * e2 + a1 * h2
		new_g = a1 * c2 + a1 * f2 + a1 * i2

		dot_matrix = [new_a, new_d, new_g]

		return dot_matrix


	def apply_rotation():
		matrice_rot_x = [[1, 0, 0], 
						 [0, math.cos(thetaX), -math.sin(thetaX)],
						 [0, math.sin(thetaX),  math.cos(thetaX)]]

		matrice_rot_y = [[math.cos(thetaY), 0,  math.sin(thetaY)], 
						 [0, 1,  0],
						 [-math.sin(thetaY), 0,  math.cos(thetaY)]]
	
		matrice_rot_z = [[math.cos(thetaZ), -math.sin(thetaZ), 0], 
						 [math.sin(thetaZ), math.cos(thetaZ), 0],
						 [0, 0, 1]]





