### ------------------------------ ###
### Unsatisfied polar atom checker ###
### It computes interaction list with IChem and outputs number of polar atoms that do not are in the interaction list ###
### /!\ Intramolecular H bond are computed and polar atoms that does intra H bond are not considered as unsatisfied ###
### /!\ Since the list of interactions can be obtain with single mol2 file, 
### when a multi mol2 file is provided it writes a single mol2 for each entry and delete it since the calculation is over ###


import mol2reader_v3 as m2r
import subprocess
import argparse
import os
import math
import sys

parser = argparse.ArgumentParser()
parser.add_argument('-l', '--ligand', type=str, required=True,
            help=' ligand mol2')
parser.add_argument('-p', '--protein', type=str, required=True,
            help=' protein or site mol2')
parser.add_argument('-o', '--output', type=str, required=True,
            help=' output tsv')
parser.add_argument('--conf', type=str, required=False, default="interpolar_checker.conf",
            help=' .conf file, by default it reads the file interpolar_checker.conf')
parser.add_argument('--intra', action='store_true', required=False,
            help=' compute intra H bond')
parser.add_argument('--id', action='store_true', required=False,
            help=' output unsatified ids')
args = parser.parse_args()



def read_conf_file(path_):

	exe_ichem = None
	lower_dist = None
	upper_dist = None
	lower_angle = None
	upper_angle = None

	with open(path_, 'r') as file_conf_hdl:
		for line in file_conf_hdl:
			if line.find("#") == -1:
				if line.find("ICHEM_PATH") != -1:
					print()
					exe_ichem = line[:-1][len("ICHEM_PATH="):]
				if line.find("LOWER_DIST") != -1:
					lower_dist = line[:-1][len("LOWER_DIST="):]
				if line.find("UPPER_DIST") != -1:
					upper_dist = line[:-1][len("UPPER_DIST="):]
				if line.find("LOWER_ANGLE") != -1:
					lower_angle = line[:-1][len("LOWER_ANGLE="):]
				if line.find("UPPER_ANGLE") != -1:
					upper_angle = line[:-1][len("UPPER_ANGLE="):]

		if exe_ichem == None or lower_dist == None or upper_dist == None\
			or lower_angle == None or upper_angle == None:
			print("Bad parameters in ", path_)
			sys.exit(2)
		else:

			return exe_ichem, lower_dist, upper_dist, lower_angle, upper_angle

def gen_IFP(exe_path_, site_, pose_):

	'''
		Launch IChem and get output from the terminal
	'''
	cmd = "{} --polar IFP {} {} | grep -E \"HBond|Ionic\"".format(exe_path_, site_, pose_) ## Very dirty but avoid annoying IChem WARNING
	command = subprocess.Popen(cmd, shell=True, stdout=subprocess.PIPE)
	output = command.communicate()[0]
	return output.decode()

def angle(coord_1_, coord_2_, coord_3_, deg_ = True):

	pi = math.pi

	a = math.dist(coord_2_, coord_1_)
	b = math.dist(coord_2_, coord_3_)
	c = math.dist(coord_1_, coord_3_)

	calcul = (-(c*c) + (a*a) + (b*b)) / (2*a*b)
	if calcul < 1 and calcul > -1:
		angle = math.acos(calcul)
	else:
		angle = 2*pi

	return angle * 180/pi


if __name__ == "__main__":

	# allowed Atom type to be H bond acceptor
	allowed_acceptor = ["N.ar", "N.2", "N.1", "O.3", "O.2", "O.co2"]

	# Reading conf file
	exe_ichem, lower_dist, upper_dist, lower_angle, upper_angle = read_conf_file(args.conf)

	multi_mol2_ligand = m2r.Loader.load_multi_mol2(args.ligand)

	output_count_unsatisfied = []

	for mol2_ligand in multi_mol2_ligand:
		try:

			### Interactions are only output if a single mol2 is given as a paramater
			# We have to deal with it, so a single mol2 is writen for each entry if a multi mol2 file is given as input
			with open("ICHEM_TEMP.mol2", 'w') as file_ichem_temp_hdl:
				file_ichem_temp_hdl.write(mol2_ligand.build())

			output_IChem = gen_IFP(exe_ichem, args.protein, "ICHEM_TEMP.mol2")
			
			os.system("rm ICHEM_TEMP.mol2")

			### Parsing IChem output

			interactions = {"Ionic" : [], "HBond DON" : [],  "HBond ACC" : []}
			for interaction in output_IChem.split("\n"):
				if interaction != "":
					type_interaction_dirty, name_atom_protein, id_atom_protein, residue, name_atom_ligand, id_atom_ligand, *trash_info = interaction.split("|")
					type_interaction = type_interaction_dirty.strip()

					if type_interaction.find("Ionic") != -1:
						if not id_atom_ligand in interactions["Ionic"]:
							interactions["Ionic"].append(int(id_atom_ligand.strip()))
					elif type_interaction.find("HBond LIG") != -1:
						if not id_atom_ligand in interactions["HBond DON"]:
							interactions["HBond DON"].append(int(id_atom_ligand.strip()))
					elif type_interaction.find("HBond PROT") != -1:
						if not id_atom_ligand in interactions["HBond ACC"]:
							interactions["HBond ACC"].append(int(id_atom_ligand.strip()))

			possible_interactions = {"Ionic PLUS" : [], "Ionic MINUS" : [], "HBond DON" : [],  "HBond ACC" : []}

			### Comparison between atoms from output IChem and polar atom from the input mol2
			for atom in mol2_ligand.atoms:

				if atom.type_atom.find("N") != -1 or atom.type_atom.find("O") != -1:
					
					## Donor
					"""
					Any N, O linked to a H
					"""
					id_neighbors_atom = mol2_ligand.get_neighbors_id_from_atom_id(atom.id_atom)
					for id_neighbor_atom in id_neighbors_atom:
						type_neighbor = mol2_ligand.atoms[id_neighbor_atom - 1].type_atom
						if type_neighbor == "H":
							possible_interactions["HBond DON"].append(atom.id_atom)
							break

					## Acceptor 
					"""
					"""
					if atom.type_atom in allowed_acceptor:

						linked_to_H = False
						if atom.type_atom == "O.3":
							possible_interactions["HBond ACC"].append(atom.id_atom)
						else:
							id_neighbors_atom = mol2_ligand.get_neighbors_id_from_atom_id(atom.id_atom)
							for id_neighbor_atom in id_neighbors_atom:
								if type_neighbor == "H":
									linked_to_H = True
									break

							if linked_to_H == False:
								possible_interactions["HBond ACC"].append(atom.id_atom)
				
					## Ionic
					if atom.charge == 1 or atom.type_atom == "N.4":
						possible_interactions["Ionic PLUS"].append(atom.id_atom)
					elif atom.charge == -1:
						possible_interactions["Ionic MINUS"].append(atom.id_atom)


			# Is atom satisfied ?
			unsatisfied_atoms = {"Ionic PLUS" : [], "Ionic MINUS" : [], "HBond DON" : [],  "HBond ACC" : []}


			for id_atom_possible_inter in possible_interactions["HBond DON"]:
				if id_atom_possible_inter not in interactions["HBond DON"] and id_atom_possible_inter not in interactions["Ionic"]:
					unsatisfied_atoms["HBond DON"].append(id_atom_possible_inter)

			for id_atom_possible_inter in possible_interactions["HBond ACC"]:
				if id_atom_possible_inter not in interactions["HBond ACC"] and id_atom_possible_inter not in interactions["Ionic"]:
					if not id_atom_possible_inter in unsatisfied_atoms["HBond DON"]:  # For exemple if O.3 with a H is not doing HBOND Donor and Acceptor, I will not count twice in unsatisfied atom
						unsatisfied_atoms["HBond ACC"].append(id_atom_possible_inter)

			for id_atom_possible_inter in possible_interactions["Ionic PLUS"]:
				if id_atom_possible_inter not in interactions["Ionic"] and id_atom_possible_inter not in interactions["HBond DON"]: # If charged plus atom (e.g. N.4) with H is doing a HBond it's ok, it will be not accounted as unsatisfied ionic atom
					if id_atom_possible_inter in unsatisfied_atoms["HBond DON"]: # if atom is both ionic and hbond donor, it will be counted as unsatisfied ionic
						unsatisfied_atoms["Ionic PLUS"].append(id_atom_possible_inter)
						unsatisfied_atoms["HBond DON"].remove(id_atom_possible_inter)
					else:
						unsatisfied_atoms["Ionic PLUS"].append(id_atom_possible_inter)

			for id_atom_possible_inter in possible_interactions["Ionic MINUS"]:
				if id_atom_possible_inter not in interactions["Ionic"] and id_atom_possible_inter not in interactions["HBond ACC"]: # If charged minus atom (e.g. O.co2) with lone pair is doing a HBond it's ok, it will be not accounted as unsatisfied ionic atom
					if id_atom_possible_inter in unsatisfied_atoms["HBond ACC"]: # if atom is both ionic and hbond acceptor, it will be counted as unsatisfied ionic
						unsatisfied_atoms["Ionic MINUS"].append(id_atom_possible_inter)
						unsatisfied_atoms["HBond ACC"].remove(id_atom_possible_inter)
					else:
						unsatisfied_atoms["Ionic MINUS"].append(id_atom_possible_inter)


			# If not check if he's doing internal hbond interaction, if --intra is given as parameter
			if args.intra == True:
				donors_satisfied_by_intra = []
				acceptors_satisfied_by_intra = []
				count_intra = 0

				for id_atom_donor in possible_interactions["HBond DON"]:
					coords_H_Donor = []
					coord_donor_unsatisfied = mol2_ligand.get_coord_from_atom_id(id_atom_donor)

					id_neighbors_atom = mol2_ligand.get_neighbors_id_from_atom_id(id_atom_donor)
					for id_neighbor_atom in id_neighbors_atom:
						type_neighbor = mol2_ligand.atoms[id_neighbor_atom - 1].type_atom
						if type_neighbor == "H":
							coords_H_Donor.append(mol2_ligand.get_coord_from_atom_id(id_neighbor_atom))

					for id_atom_acceptor in possible_interactions["HBond ACC"]:
						if id_atom_acceptor != id_atom_donor:
							coord_acceptor = mol2_ligand.get_coord_from_atom_id(id_atom_acceptor)
							distance_intra = math.dist(coord_donor_unsatisfied, coord_acceptor)

							if int(lower_dist) <= distance_intra <= int(upper_dist):
								for coord_H in coords_H_Donor:
									angle_intra = angle(coord_donor_unsatisfied, coord_H, coord_acceptor)
									if int(lower_angle) <= angle_intra <= int(upper_angle):
										donors_satisfied_by_intra.append(id_atom_donor)
										acceptors_satisfied_by_intra.append(id_atom_acceptor)
										count_intra += 1

				for donor_satisfied_by_intra in donors_satisfied_by_intra:
					if donor_satisfied_by_intra in unsatisfied_atoms["HBond DON"]:
						unsatisfied_atoms["HBond DON"].remove(donor_satisfied_by_intra)
					if donor_satisfied_by_intra in unsatisfied_atoms["Ionic PLUS"]:
						unsatisfied_atoms["Ionic PLUS"].remove(donor_satisfied_by_intra)

				for acceptor_satisfied_by_intra in acceptors_satisfied_by_intra:
					if acceptor_satisfied_by_intra in unsatisfied_atoms["HBond ACC"]:
						unsatisfied_atoms["HBond ACC"].remove(acceptor_satisfied_by_intra)
					if acceptor_satisfied_by_intra in unsatisfied_atoms["Ionic MINUS"]:
						unsatisfied_atoms["Ionic MINUS"].remove(acceptor_satisfied_by_intra)

			else:
				count_intra = "/"

			output_count_unsatisfied.append([mol2_ligand.molecule.name, unsatisfied_atoms["Ionic PLUS"] + unsatisfied_atoms["Ionic MINUS"],  unsatisfied_atoms["HBond DON"], unsatisfied_atoms["HBond ACC"], count_intra])

		except:
			print("ERROR IChem with entry :", mol2_ligand.molecule.name, output_IChem)

	
	with open(args.output, 'w') as file_output_hdl:

		if args.id == False:
		
			file_output_hdl.write('{}\t{}\t{}\t{}\t{}\n'.format("NAME", "UNSAT_IONIC", "UNSAT_DONOR", "UNSAT_ACCEPTOR", "INTRA_BOND"))
		
			for unsatisfied_count in output_count_unsatisfied:

				name, ionic_unsat, hbond_donor_unsat, hbond_acceptor_unsat, intra_bond_count = unsatisfied_count
				file_output_hdl.write('{}\t{}\t{}\t{}\t{}\n'.format(name, len(ionic_unsat), len(hbond_donor_unsat), len(hbond_acceptor_unsat), intra_bond_count))

		### if --id is given as parameter, it outputs unsatisfied polar atom ids
		else:

			file_output_hdl.write('{}\t{}\t{}\t{}\t{}\t{}\n'.format("NAME", "UNSAT_IONIC", "UNSAT_DONOR", "UNSAT_ACCEPTOR", "INTRA_BOND", "UNSATISFIED_IDS"))
		
			for unsatisfied_count in output_count_unsatisfied:
				name, ionic_unsat, hbond_donor_unsat, hbond_acceptor_unsat, intra_bond_count = unsatisfied_count

				unsat_ids = '"'

				for id_unsat in ionic_unsat + hbond_donor_unsat + hbond_acceptor_unsat:
					unsat_ids += '{} '.format(id_unsat)

				unsat_ids = unsat_ids[:-1] + '"'

				if unsat_ids == '"':
					unsat_ids = '"/"'

				file_output_hdl.write('{}\t{}\t{}\t{}\t{}\t{}\n'.format(name, len(ionic_unsat), len(hbond_donor_unsat), len(hbond_acceptor_unsat), intra_bond_count, unsat_ids))




