### It runs and parses the output of TorsionAnalyzer

import subprocess
import argparse


if __name__ == "__main__":

	parser = argparse.ArgumentParser()
	parser.add_argument('-i', '--input', type=str, required=True,
            help='')
	parser.add_argument('-at', '--allowedtorsion', type=int, required=True,
            help='')
	parser.add_argument('-mt', '--minimumtorsion', type=int, required=False, default=0,
            help='')
	parser.add_argument('-o', '--output', type=str, required=True,
            help='')
	args = parser.parse_args()

	
	
	### --- Fullfill with exe path of TorsionAnalyzer ###
	path_bin = "/soft/ZBH/Torsion_analyzer/TorsionAnalyzer"
	###
	
	cmd = '{} -i {} -o TEMP_output_torsion.out'.format(path_bin, args.input)
	command = subprocess.Popen(cmd, shell=True)

	dico_torsion = {}

	with open('TEMP_output_torsion.out', 'r') as file_torsion_analyzer_hdl:
		for line in file_torsion_analyzer_hdl:
			if line.find("entry") == -1:
				name = line.split()[1]
				bond_state = line.split()[7]
				if not name in dico_torsion:
					dico_torsion[name] = 0
				if bond_state == "strained":
					dico_torsion[name] = dico_torsion[name] + 1

	with open(args.output, 'w') as file_output_hdl:
		for name, count in dico_torsion.items():
			if args.minimumtorsion <= count <= args.allowedtorsion:
				file_output_hdl.write('{}\t{}\n'.format(name, count))



