#!/usr/bin/perl

use strict;
use Getopt::Long;
my $bins = '';
my $props = '';
my $out = '';
my $help = '';

my $arg = GetOptions('help'=>\$help,
				'props=s'=>\$props,
				'out=s' => \$out,
				'bins=s' =>\$bins
				);

if($help) {
	print "This script generate Cavity fingerprint definition file. This is the input for fingerprint generation from cavity files.\n";
	print "usage:\n";
	print "\tINPUTS:\n";
	print "\t--props or -p :\t\"list of properties\" (ex: \"d,a,+,-,ar,ap,m\")\n";
	print "\t--bins or -b :\t\"list of bins\" (ex: \"0,2.5,4,6,9,13,18\")\n";
	print "\tOUTPUTS:\n";
	print "\t--out or -o :\tdefinition file (standard output if missing) \n";
	
	exit;
}	

if (!$props
	|| !$bins){
	print "please fill all the parametters.\nTry -h\n";
	exit;
}



my @prop = split (/,/,$props);
my @borne = split (/,/,$bins);


print STDERR "bins : @borne\n";
print STDERR "properties : @prop\n";




if ($out){
	open (OUT, ">$out");
	select  (OUT);
}

my ($count,$comb) = @{calcComb(\@prop,\@borne)};
print  "bins : @borne\n";
print "properties : @prop\n";

print $comb;
select (STDERR);
print  $count." combinations generated :D Nathanael Weill\n";

sub calcComb{
	my $res =0;
	my %hashSeen;
	my $comb;
	my $fpID =0;
	my @prop = @{$_[0]};
	my @borne = @{$_[1]};

	my $nbProp = $#prop + 1;
	my $distMax = $#borne + 1;
	

	for (my $i = 0; $i < $distMax ; $i++){
		for (my $j = $i ; $j < $distMax ; $j++){
			for (my $k = $j ; $k < $distMax ; $k++){
				my @tab = ($k,$j,$i);
				
				
				my %hash2;
				$hash2{$i}++;
				$hash2{$j}++;
				$hash2{$k}++;
				my $nbD = scalar (keys(%hash2));
				
				if (($borne  [$tab[0]] <= ($borne[$tab[1]+1]+$borne[$tab[2]+1]) )
					&&$borne  [$tab[0]+1] >= $borne[$tab[1]]
					&&$borne  [$tab[0]+1] >= $borne[$tab[2]]
					){
				
				
					my $triBorne = sprintf("%.1f-%.1f;%.1f-%.1f;%.1f-%.1f:",$borne[$tab[0]],$borne[$tab[0]+1],$borne[$tab[1]],$borne[$tab[1]+1],$borne[$tab[2]],$borne[$tab[2]+1]);
					
					
					for (my $l =0 ; $l <= $#prop; $l++){
						my $prop1 =$prop[$l];
						for (my $m =$l ; $m <= $#prop; $m++){
							my $prop2 = $prop[$m];
							for (my $n =$m; $n <= $#prop; $n++){
								my $prop3 =$prop[$n];
								my $temp=0;
								my %hash1;
								$hash1{$prop1}++;
								$hash1{$prop2}++;
								$hash1{$prop3}++;
								my $nbP =  scalar (keys(%hash1));
								my $tri = $triBorne;
								if ($nbD ==1 || $nbP ==1){#ok
									if (!defined($hashSeen{"$tri$prop1;$prop2;$prop3:$fpID"})){
										$comb .= "$tri$prop1;$prop2;$prop3:$fpID\n";
										$hashSeen{"$tri$prop1;$prop2;$prop3:$fpID"} = 1;
									}
									if (!defined($hashSeen{"$tri$prop1;$prop3;$prop2:$fpID"})){
										$comb.= "$tri$prop1;$prop3;$prop2:$fpID\n";
										$hashSeen{"$tri$prop1;$prop3;$prop2:$fpID"}=1;
									}
									
									if (!defined($hashSeen{"$tri$prop2;$prop1;$prop3:$fpID"})){
										$comb.= "$tri$prop2;$prop1;$prop3:$fpID\n";
										$hashSeen{"$tri$prop2;$prop1;$prop3:$fpID"} = 1;
									}
									if (!defined($hashSeen{"$tri$prop2;$prop3;$prop1:$fpID"})){
										$comb.= "$tri$prop2;$prop3;$prop1:$fpID\n";
										$hashSeen{"$tri$prop2;$prop3;$prop1:$fpID"} = 1;
									}
									if (!defined($hashSeen{"$tri$prop3;$prop1;$prop2:$fpID"})){
										$comb.= "$tri$prop3;$prop1;$prop2:$fpID\n";
									$hashSeen{"$tri$prop3;$prop1;$prop2:$fpID"} = 1;
									}
									if (!defined($hashSeen{"$tri$prop3;$prop2;$prop1:$fpID"})){
										$comb.= "$tri$prop3;$prop2;$prop1:$fpID\n";
										$hashSeen{"$tri$prop3;$prop2;$prop1:$fpID"} = 1;
									}
									$fpID++;
								}else{
									if( ($nbD ==2) && ($nbP ==2) ){
										my $temp = $fpID;
										if ($k == $j){
											if ($prop1 eq $prop2){
												$comb.= "$tri$prop1;$prop2;$prop3:$temp\n";
												$comb.= "$tri$prop1;$prop3;$prop2:$temp\n";
												$temp++;
												$comb.= "$tri$prop3;$prop1;$prop2:$temp\n";
											}elsif($prop2 eq $prop3){
												$comb.= "$tri$prop1;$prop2;$prop3:$temp\n";
												$temp++;
												$comb.= "$tri$prop3;$prop1;$prop2:$temp\n";
												$comb.= "$tri$prop3;$prop2;$prop1:$temp\n";
											}
											
										}elsif ($j == $i){
											if ($prop1 eq $prop2){
												$comb.= "$tri$prop1;$prop2;$prop3:$temp\n";
												$comb.= "$tri$prop3;$prop2;$prop1:$temp\n";
												$temp++;
												$comb.= "$tri$prop1;$prop3;$prop2:$temp\n";
											}elsif($prop2 eq $prop3){
												$comb.= "$tri$prop1;$prop2;$prop2:$temp\n";
												$comb.= "$tri$prop2;$prop2;$prop1:$temp\n";
												$temp++;
												$comb.= "$tri$prop2;$prop1;$prop2:$temp\n";
												
											}
											
										}
										$fpID+=2;
										
										
									}
									if(($nbD ==2) &&($nbP == 3)){#ok
										my $temp = $fpID;
										if ($k == $j){
										
											$comb.= "$tri$prop1;$prop2;$prop3:$temp\n";
											$comb.= "$tri$prop1;$prop3;$prop2:$temp\n";
										
											$temp++;
											$comb.= "$tri$prop3;$prop1;$prop2:$temp\n";
											$comb.= "$tri$prop3;$prop2;$prop1:$temp\n";
											$temp++;
											$comb.= "$tri$prop2;$prop3;$prop1:$temp\n";
											$comb.= "$tri$prop2;$prop1;$prop3:$temp\n";
											$temp++;
										}
										if ($j == $i){
											$comb.= "$tri$prop1;$prop2;$prop3:$temp\n";
											$comb.= "$tri$prop3;$prop2;$prop1:$temp\n";
										
											$temp++;
											$comb.= "$tri$prop3;$prop1;$prop2:$temp\n";
											$comb.= "$tri$prop2;$prop1;$prop3:$temp\n";
											$temp++;
											$comb.= "$tri$prop2;$prop3;$prop1:$temp\n";
											$comb.= "$tri$prop1;$prop3;$prop2:$temp\n";
											$temp++;
										}
										$fpID +=3;
										
									 }
									 if(($nbD == 3)&&($nbP == 3)){#ok
										
										
										$comb.= "$tri$prop1;$prop2;$prop3:$fpID\n";
										$fpID++;
										$comb.= "$tri$prop1;$prop3;$prop2:$fpID\n";
										$fpID++;
										$comb.= "$tri$prop2;$prop1;$prop3:$fpID\n";
										$fpID++;
										$comb.= "$tri$prop2;$prop3;$prop1:$fpID\n";
										$fpID++;
										$comb.= "$tri$prop3;$prop1;$prop2:$fpID\n";
										$fpID++;
										$comb.= "$tri$prop3;$prop2;$prop1:$fpID\n";
										$fpID++;
											
									}
									if(($nbD == 3)&&$nbP == 2){
										
										
										$comb.= "$tri$prop1;$prop2;$prop3:$fpID\n";
										
										$fpID++;
										$comb.= "$tri$prop3;$prop1;$prop2:$fpID\n";
										$fpID++;
										$comb.= "$tri$prop2;$prop3;$prop1:$fpID\n";
										$fpID++;
									
									}
								}
									
								
								
								
								
							}
						}
						
					}
					
				
				}
			}
		}
	}
	my @res = ($fpID,$comb);
	return \@res;
}
