package main;

import io.Mol2Reader;
import io.PharmacophoreDefReader;
import io.PropertiesBuilder;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;



import utils.NotDefException;

import data.Atom;
import data.FPFactory;
import data.FingerPrint;
import data.Triangle;
import data.TriangleFactory;

public class Main {

	/**
	 * @param args
	 */
	public static void main(String[] args) {
		double debut = System.nanoTime();
		Hashtable<String, String> arguments = Main.parseArgs(args);
		String defProp = arguments.get("defProp");
		String defTri = arguments.get("defTri");
		String out = arguments.get("out");
		
		

		try {
			
			PropertiesBuilder pb = new PropertiesBuilder(defProp);
			PharmacophoreDefReader pdr = new PharmacophoreDefReader(defTri);
			BufferedWriter bwStat = null;
			if (arguments.containsKey("stat")){
				FileWriter stat = new FileWriter(arguments.get("stat")) ;
				 bwStat= new BufferedWriter(stat);
			}
			FileWriter fw = new FileWriter(out);
			BufferedWriter bw = new BufferedWriter(fw);
			FPFactory fpf = new FPFactory(pdr,arguments.get("mode"));
			if (arguments.containsKey("in")){
				Mol2Reader mr = new Mol2Reader(arguments.get("in"));

				ArrayList<Atom> atList = mr.getListAt();

				for (int i = 0 ; i < atList.size() ; i++){
					Atom at = atList.get(i);
					
					at.setProperties(pb.assignProp(at));
					
					atList.set(i, at);

				}

				ArrayList<Triangle> listTri = new ArrayList<Triangle>();
				TriangleFactory tf = new TriangleFactory(bwStat);
				for (int i=0; i < atList.size() ; i++ )
					for (int j=i+1; j < atList.size() ; j++ )
						for (int k=j+1; k < atList.size() ; k++ ){
							listTri.addAll(tf.buildTriangle(atList.get(i), atList.get(j), atList.get(k)));

						}
				System.out.println("triangles généré "+(System.nanoTime()-debut)/Math.pow(10,9));

				FingerPrint fp = fpf.computeFp(listTri);
				System.out.println("Fingerprint genéré "+(System.nanoTime()-debut)/Math.pow(10,9));
				System.out.print(fp);
				System.out.println(" in "+mr.getName()); 

				fw.write(mr.getName()+" : "+fp.getFp()+"\n");
			}else {
				FileReader fr = new FileReader(arguments.get("list"));
				BufferedReader br = new BufferedReader(fr);
				String line ="";
				while ((line = br.readLine())!=null){
					if (!line.trim().matches("^\\s*$")){
						Mol2Reader mr = new Mol2Reader(line.trim());
						ArrayList<Atom> atList = mr.getListAt();

						for (int i = 0 ; i < atList.size() ; i++){
							Atom at = atList.get(i);
							at.setProperties(pb.assignProp(at));
							atList.set(i, at);

						}
						ArrayList<Triangle> listTri = new ArrayList<Triangle>();
						TriangleFactory tf = new TriangleFactory(bwStat);
						for (int i=0; i < atList.size() ; i++ )
							for (int j=i+1; j < atList.size() ; j++ )
								for (int k=j+1; k < atList.size() ; k++ ){
									listTri.addAll(tf.buildTriangle(atList.get(i), atList.get(j), atList.get(k)));

								}
						FingerPrint fp = fpf.computeFp(listTri);
						
						System.out.print(fp);
						System.out.println(" in "+mr.getName()); 

						fw.write(mr.getName()+" : "+fp.getFp()+"\n");
					
					}
				}
				
			}
			fw.close();
			bw.close();
			//System.out.println(fp.getFp());
		} catch (IOException e1) {
			// TODO Auto-generated catch block
			e1.printStackTrace();
		} catch (NotDefException e) {
			System.err.println(e.myCause());
			e.printStackTrace();
		}
		System.out.println((System.nanoTime()-debut)/Math.pow(10,9));
	}


	private static  void printUsage(){
		System.err.println("Generate fingerprint of Cavity using 3-point pharamcophores.");
		
		System.err.println("************************************************************");
		System.err.println("");
		System.err.println("             Written by Nathanael Weill");
		System.err.println("");
		System.err.println("************************************************************");
		System.err.println("Usage:");
		System.err.println("\t-d [file] = Definition of properties per Residus (tableDef.txt)");
		System.err.println("\t-t [file] = definition of triangle (distances intervals + properties to use)");
		System.err.println("\tmode 1 : -i [file] = mol2 file containing HS annotations.");
		System.err.println("\tmode 2 : -l [file] = file containing a list of mol2 file.");
		System.err.println("\t-o [file] = file containing fingerprint(s)");
		System.err.println("\t-s [file] = file containing all distances computed (optional)");
		System.err.println("FLAGS:");
		System.err.println("\t-c : set fingerprint as counts instaead of binary (default binary)");
	}

	private static Hashtable<String, String> parseArgs(String[] args){
		Hashtable<String, String> res = new Hashtable<String, String>();
		for (int i = 0; i< args.length ; i++){
			if (args[i].equals("-d")){
				res.put("defProp", args[i+1]);
			}
			if (args[i].equals("-t")){
				res.put("defTri", args[i+1]);
			}
			if (args[i].equals("-o")){
				res.put("out", args[i+1]);
			}
			if (args[i].equals("-i")){
				res.put("in", args[i+1]);
			}
			if (args[i].equals("-l")){
				res.put("list", args[i+1]);
			}
			if (args[i].equals("-s")){
				res.put("stat", args[i+1]);
			}
			if (args[i].equals("-c"))
				res.put("mode","count");
		}

		if (!res.containsKey("defProp")
				||!res.containsKey("defTri")
				||!res.containsKey("out")
				||(!res.containsKey("in")&&!res.containsKey("list"))
				){
			printUsage();
			System.exit(1);
		}
		if (res.containsKey("in")&&res.containsKey("list")){
			System.err.println("please choose one mode 1 or 2");
			printUsage();
			System.exit(1);
		}
		if (!res.containsKey("mode")){
			res.put("mode", "binary");
		}



		return res;
	}
	
	

}
