package io;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;

import utils.NotDefException;

import data.Atom;

public class PropertiesBuilder {

	
	private String resDef="";
	private Hashtable <String,ArrayList<String>> props = new Hashtable<String, ArrayList<String>>(); 
	
	public PropertiesBuilder() {
		
	}

	public PropertiesBuilder(String resDef) {
		
		this.resDef = resDef;
		try {
			FileReader fr = new FileReader(this.resDef);
			BufferedReader br =new  BufferedReader(fr);
			String line = "";
			while ((line = br.readLine())!= null){
				String [] mots = line.trim().split("\\s+");
				String [] properties = null;
				ArrayList<String> tmp = new ArrayList<String>();
				if (mots.length >2){
					properties =mots[2].split(",");
					
					for (int i = 0; i <properties.length ; i++)
						tmp.add(properties[i]);
				}
				this.props.put(mots[0]+":"+mots[1], tmp);
				
			}
			
			
		} catch (FileNotFoundException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		
	}
	
	public ArrayList<String> assignProp (Atom at)throws NotDefException{
		if (!this.props.containsKey(at.getResiduName()+":"+at.getName()) 
				&& ((at.getName().toUpperCase().equals("FE")
						||at.getName().toUpperCase().equals("MN")
						||at.getName().toUpperCase().equals("ZN")
						||at.getName().toUpperCase().equals("NI")
						||at.getName().toUpperCase().equals("CU")
						||at.getName().toUpperCase().equals("CD")
						||at.getName().toUpperCase().equals("CO")) &&!this.props.containsKey(at.getName()+":"+at.getName()))
				) //metal cases
				throw new NotDefException(at.getResiduName()+":"+at.getName() + ";"+at);
		if (at.isOXTres()&&at.getType().equals("O.2")){
			ArrayList<String> res = new ArrayList<String>(this.props.get(at.getResiduName()+":"+at.getName()));
			
			res.add("-");
			return res;
		}else {
			ArrayList<String> res = new ArrayList<String>();
			if (at.getName().toUpperCase().equals("FE")
					||at.getName().toUpperCase().equals("MN")
					||at.getName().toUpperCase().equals("ZN")
					||at.getName().toUpperCase().equals("NI")
					||at.getName().toUpperCase().equals("CU")
					||at.getName().toUpperCase().equals("CD")
					||at.getName().toUpperCase().equals("CO")
					 ) {
				
				res = new ArrayList<String>(this.props.get(at.getName()+":"+at.getName()));
				return res;
			}
			return this.props.get(at.getResiduName()+":"+at.getName());
		}
	}

	/**
	 * @param args
	 */
	public static void main(String[] args) {
		PropertiesBuilder pb = new PropertiesBuilder(args[0]);
		System.out.println(pb.props);

	}

}
