package io;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;


import java.util.Hashtable;

public class PharmacophoreDefReader {

	/**
	 * @param args
	 */
	
	private String fileDef = "";
	private ArrayList<String> propUsed = new ArrayList<String>();
	private double[] bins;
	private Hashtable<String,Integer> hashFP ;
	private int fpSize = 0;
	
	public static void main(String[] args) {
		PharmacophoreDefReader pdr = new PharmacophoreDefReader(args[0]);
		
		System.out.println(pdr.hashFP.size());
		

	}

	public PharmacophoreDefReader() {
		
	}

	public PharmacophoreDefReader(String fileDef) {
		this.fileDef = fileDef;
		this.hashFP =  new Hashtable <String,Integer>();
		try {
			FileReader fr = new FileReader(this.fileDef);
			BufferedReader br = new BufferedReader (fr);
			String line = "";
			
			while ((line = br.readLine())!= null){
				String []mots = line.split(":");
				if (line.matches("bins.*")){
					String [] temp =mots[1].trim().split("\\s+");
					this.bins = new double[temp.length];
					for (int i = 0; i< temp.length ; i++)
						this.bins[i] = new Double(temp[i]).doubleValue();
				}else if (line.matches("properties.*")){
					String [] temp =mots[1].trim().split("\\s+");
					for (int i = 0 ; i < temp.length ; i++)
						this.propUsed.add(temp[i]);
				}else{
					this.hashFP.put(mots[0]+":"+mots[1], new Integer(mots[2]));
					this.fpSize = new Integer(mots[2]).intValue();
				}
			}
			
		} catch (FileNotFoundException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		
	}

	public int getFpSize() {
		return fpSize+1;
	}

	public double[] getBins() {
		return bins;
	}

	public ArrayList<String> getPropUsed() {
		return propUsed;
	}
	
	public int getFpPosition(String tri){
		if (!this.hashFP.containsKey(tri)){
			System.out.println(tri);
		}
		return this.hashFP.get(tri).intValue();
	}
	
	
	
	

}
