package io;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;

import data.Atom;

public class Mol2Reader {

	private String mol2fileName = "";
	private ArrayList<Atom> listAt = new ArrayList<Atom>();
	private String resOXT = "";
	private String molName = "";
	
	public Mol2Reader(String mol2fileName) {
		this.mol2fileName = mol2fileName;
		try {
			FileReader fr = new FileReader(this.mol2fileName);
			BufferedReader br = new BufferedReader(fr);
			String line = "";
			boolean atomFlag= false;
			boolean nameFlag = false;
			String resOxt = "";
			while ((line = br.readLine())!= null){
				if (line.startsWith("@<TRIPOS>BOND"))
					atomFlag = false;
				
				if (atomFlag){
					String [] mots= line.split("\\s+");
					mots[8]=mots[8].replaceAll("\\d", "");
					
					if (mots[2].equals("OXT"))
						resOxt = mots[8]+mots[7];
					if (mots[9].equals("40.0000")){
						
						
						Atom at = new Atom(new Double(mots[3]).doubleValue(),
								new Double(mots[4]).doubleValue(),
								new Double(mots[5]).doubleValue(),
								new Integer(mots[1]).intValue(),
								mots[2],
								mots[6],
								mots[8],
								mots[7]
								);
						this.listAt.add(at);
					}
					
					
				}
				
				if (line.startsWith("@<TRIPOS>ATOM"))
					atomFlag = true;
				
				if (nameFlag){
					this.molName = line.trim();
					nameFlag = false;
				}
					
				
				if (line.startsWith("@<TRIPOS>MOLECULE"))
					nameFlag = true;
				
				
			}
			for (int i = 0 ; i < this.listAt.size() ; i++){
				Atom at = listAt.get(i);
				if ((at.getResiduName()+at.getResID()).equals(resOxt)){
					at.setOXTres(true);
					listAt.set(i, at);
				}
			}
			
		} catch (FileNotFoundException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		
		
	}

	public Mol2Reader() {
		
	}
	
	public static void main(String[] args) {
		
		Mol2Reader mr = new Mol2Reader(args[0]);
		
		System.out.println(mr.getListAt().size());
		Iterator<Atom> it = mr.getListAt().iterator();
		while (it.hasNext()){
			Atom at = it.next();
			if (at.isOXTres())
				System.out.println(at);
		}
	}

	public ArrayList<Atom> getListAt() {
		return listAt;
	}

	public void setListAt(ArrayList<Atom> listAt) {
		this.listAt = listAt;
	}

	public String getResOXT() {
		return resOXT;
	}

	public String getName() {
		return molName;
	}

}
