package data;

import java.util.ArrayList;
import java.util.Iterator;

import utils.NotDefException;

import io.PharmacophoreDefReader;

public class FPFactory {

	private PharmacophoreDefReader pdr = new PharmacophoreDefReader();
	private String mode = "";
	
	public FPFactory(PharmacophoreDefReader pdr) {
		this.pdr = pdr;
	}
	public FPFactory(PharmacophoreDefReader pdr,String mode) {
		this.pdr = pdr;
		this.mode = mode;
	}

	public FPFactory() {
		
	}

	public FingerPrint computeFp   (ArrayList <Triangle> listTri) throws NotDefException{
		FingerPrint fp;
		if (this.mode.equals("count"))
			fp= new FingerPrintCount(this.pdr.getFpSize());
		else 
			fp= new FingerPrintBin(this.pdr.getFpSize());
		
		Iterator<Triangle> it = listTri.iterator();
		while (it.hasNext()){
			Triangle t = it.next();
			
			String interval1 = intervalFounder(t.getDist1());
			String interval2 = intervalFounder(t.getDist2());
			String interval3 = intervalFounder(t.getDist3());
			String defTri = interval1+";"
			+interval2+";"
			+interval3+":"
			+t.getProp1()+";"
			+t.getProp2()+";"
			+t.getProp3();
			if ((!pdr.getPropUsed().contains(t.getProp1()))
					||(!pdr.getPropUsed().contains(t.getProp2()))
					||(!pdr.getPropUsed().contains(t.getProp3())))
				throw new NotDefException(t+"\n"+defTri+"\n");
			if ((!interval1.equals(""))&&(!interval2.equals(""))&&(!interval3.equals("")))
				fp.setOn(pdr.getFpPosition(defTri));
		}
		
		
		return fp;
	}
	
	private String  intervalFounder(double dist){
		String res = "";
		for (int i = 1 ; i < pdr.getBins().length ; i++)
			if (dist < pdr.getBins()[i]){
				res = pdr.getBins()[i-1]+"-"+pdr.getBins()[i];
				break;
			}
		return res;
	}
	
}
