/*
 * Decompiled with CFR 0.152.
 */
package data;

import data.FingerPrint;
import data.FingerPrintBin;
import data.FingerPrintCount;
import data.Triangle;
import io.PharmacophoreDefReader;
import java.util.ArrayList;
import utils.NotDefException;

public class FPFactory {
    private PharmacophoreDefReader pdr = new PharmacophoreDefReader();
    private String mode = "";

    public FPFactory(PharmacophoreDefReader pdr) {
        this.pdr = pdr;
    }

    public FPFactory(PharmacophoreDefReader pdr, String mode) {
        this.pdr = pdr;
        this.mode = mode;
    }

    public FPFactory() {
    }

    public FingerPrint computeFp(ArrayList<Triangle> listTri) throws NotDefException {
        FingerPrint fp = this.mode.equals("count") ? new FingerPrintCount(this.pdr.getFpSize()) : new FingerPrintBin(this.pdr.getFpSize());
        for (Triangle t : listTri) {
            String interval1 = this.intervalFounder(t.getDist1());
            String interval2 = this.intervalFounder(t.getDist2());
            String interval3 = this.intervalFounder(t.getDist3());
            String defTri = String.valueOf(interval1) + ";" + interval2 + ";" + interval3 + ":" + t.getProp1() + ";" + t.getProp2() + ";" + t.getProp3();
            if (!(this.pdr.getPropUsed().contains(t.getProp1()) && this.pdr.getPropUsed().contains(t.getProp2()) && this.pdr.getPropUsed().contains(t.getProp3()))) {
                throw new NotDefException(t + "\n" + defTri + "\n");
            }
            if (interval1.equals("") || interval2.equals("") || interval3.equals("")) continue;
            fp.setOn(this.pdr.getFpPosition(defTri));
        }
        return fp;
    }

    private String intervalFounder(double dist) {
        String res = "";
        int i = 1;
        while (i < this.pdr.getBins().length) {
            if (dist < this.pdr.getBins()[i]) {
                res = String.valueOf(this.pdr.getBins()[i - 1]) + "-" + this.pdr.getBins()[i];
                break;
            }
            ++i;
        }
        return res;
    }
}

