#include "treemedoid.hpp"
double DistNode(int clustid[],double** distMatrix){
/**********************************************************/
/*Distance between two nodes                              */
/* G. Marcou                                              */
/**********************************************************/
    double d;
    int i,j,k;
    d=-1;
    i=clustid[0];
    k=1;
    while(d==-1){
	j=clustid[k];
	if(i==j){
	    ++k;
	} else if(i<j){
	    d=distMatrix[j][i];
	} else if(i>j){
	    d=distMatrix[i][j];
	};
    };
//
    return(d);
};
/***********************************************************/
void MatrixDivide(int ncluster, int rank,
		  int clusterid[],
		  int OldId[],vector<int> NewId[],
		  double** distMatrix,
		  vector<double**> &kMatrix,
		  int ikmax[]){
/**********************************************************/
/*Divide distMatrix in ncluster distance matrix           */
/* G. Marcou                                              */
/**********************************************************/
    int i,k;
    int ikcount[ncluster];
    map<int,int> kId2Indx;
    map<int,int>::iterator _kId2Indx;
//
//Initialization of counter and dimensions
    for(k=0;k<=ncluster;++k){
	ikcount[k]=0;
	ikmax[k]=0;
    };
//
//Identify each cluster
    ncluster=0;
    for(i=0;i<rank;++i){
	_kId2Indx=kId2Indx.find(clusterid[i]);
	if(_kId2Indx!=kId2Indx.end()){
	    k=_kId2Indx->second-1;
	}else{//new index
	    ++ncluster;
	    kId2Indx[clusterid[i]]=ncluster;
	    k=ncluster-1;
	};
	NewId[k].push_back(OldId[i]);//keep track of indexing
	++ikmax[k];//Finding dimension of new matrices
    };
//
    for(k=0;k<ncluster;++k){//Preparing space for new matrices
	kMatrix.push_back(new double* [ikmax[k]]);
	kMatrix[k][0]=0;
	for(i=1;i<ikmax[k];++i)
	    kMatrix[k][i]=new double [i];
    };//End of initialization
//
//Divide entry matrix in ncluster submatrices
    for(i=0;i<rank;++i){//Screen the rows of distMatrix
	int j,jkcount;
	j=0;
	k=kId2Indx[clusterid[i]]-1;
	for(jkcount=0;jkcount<ikcount[k];++jkcount){
	    double d;
	    d=-1;
	    while(d==-1){
		if((kId2Indx[clusterid[j]]-1)==k){
		    if(j<i) d=distMatrix[i][j];
		    if(j>i) d=distMatrix[j][i];
		};
		++j;
		if(j>=rank)
		    cout << "BUG" << endl;
	    };
	    kMatrix[k][ikcount[k]][jkcount]=d;
	};
	++ikcount[k];
    };
//    
    return;
};
/***********************************************************/
void treekmedoid(int rank,int npass,double** distMatrix,
		 int OldId[],double dist_old,// string &tree,
		 int result[][2],double linkdist[]){
/**********************************************************/
/* Tree construction based on kmedoid clustering          */
/* G. Marcou                                              */
/**********************************************************/
    const int ncluster=2;
    bool visited,finished;
    double dist;//Distance between two son nodes
    double error;
    int k,ifound;
    vector<int> NewId[ncluster];
    int krank[ncluster];
    vector<double**> kMatrix;//new distance matrices
    int *clustid;
    clustid=new int [rank];
    static vector<int> prev_node;
    static int curr_node=0;
    static bool left=true;
    static bool first=true;
//
    for(k=0;k<ncluster;k++){
      krank[k]=0;
    };
//
    if(first){
	prev_node.push_back(curr_node-1);
	first=false;
    };
//
    visited=false;
    finished=false;
    k=0; dist=-1;
    while(!finished){
	if(rank>=2){//iternal node
	    if(!visited){//first time in this node
//
		++curr_node;
		if(left){
		    if(prev_node.back()>=0)
		      result[prev_node.back()][0]=-curr_node;
		}else{
		    if(prev_node.back()>=0)
		      result[prev_node.back()][1]=-curr_node;
		};
		prev_node.push_back(curr_node-1);
//
		visited=true;
//
		kmedoids(ncluster,rank,distMatrix,npass,
			 clustid,&error,&ifound);
		dist=DistNode(clustid,distMatrix);
//
		MatrixDivide(ncluster,rank,clustid,
			     OldId,NewId,distMatrix,kMatrix,krank);
//
//Go to left branch
		left=true;
 		int* Id;
 		Id=new int [krank[k]];
 		int i;
 		for(i=0;i<krank[k];++i)
 		    Id[i]=NewId[k][i];		
		treekmedoid(krank[k],npass,kMatrix[k],Id,dist,result,linkdist);
	    }else{
		++k;
		if(!finished){//next time in this node
		    if(k>=(ncluster-1))
			finished=true;//all branches processed
//
//Go to right branch
		    left=false;
		    int* Id;
		    Id=new int [krank[k]];
		    int i;
		    for(i=0;i<krank[k];++i)
			Id[i]=NewId[k][i];		
		    treekmedoid(krank[k],npass,kMatrix[k],Id,dist,result,linkdist);
		    if(finished){
		      linkdist[prev_node[prev_node.size()-2]]=dist_old;
		    };
		};
	    };
	}else{//node is a leaf
	    if(left){
		if(prev_node.back()>0)
		  result[prev_node.back()][0]=OldId[0];
	    }else{
		if(prev_node.back()>0)
		  result[prev_node.back()][1]=OldId[0];
	    };
	    prev_node.push_back(curr_node-1);//just get something pop
	    linkdist[prev_node[prev_node.size()-2]]=dist_old;
	    finished=true;
	};
    };
//
    prev_node.pop_back();
//
    return;
};
/***********************************************************/
/***********************************************************/
void treekmedoid(int rank,int npass,double** distMatrix,
		 int OldId[],double dist_old,// string &tree,
		 Node *nodes){
/**********************************************************/
/* Tree construction based on kmedoid clustering          */
/* G. Marcou                                              */
/**********************************************************/
    const int ncluster=2;
    bool visited,finished;
    double dist;//Distance between two son nodes
    double error;
    int k,ifound;
    vector<int> NewId[ncluster];
    int krank[ncluster];
    vector<double**> kMatrix;//new distance matrices
    int *clustid;
    clustid=new int [rank];
    static vector<int> prev_node;
    static int curr_node=0;
    static bool left=true;
    static bool first=true;
    //
    for(k=0;k<ncluster;k++){
      krank[k]=0;
    };
//
//    cout << "Current Node" << curr_node << endl;
//    if(curr_node==17)
//      cout << "rank" << rank << endl;
    if(first){
	prev_node.push_back(curr_node-1);
	first=false;
    };
//
    visited=false;
    finished=false;
    k=0; dist=-1;
    while(!finished){
	if(rank>=2){//iternal node
	    if(!visited){//first time in this node
//
		++curr_node;
		if(left){
		    if(prev_node.back()>=0)
		      nodes[prev_node.back()].left=-curr_node;
		}else{
		  if(prev_node.back()>=0){
		      nodes[prev_node.back()].right=-curr_node;
		      nodes[prev_node.back()].distance=0.0;
		  };		      
		};
		prev_node.push_back(curr_node-1);
//
		visited=true;
//
		kmedoids(ncluster,rank,distMatrix,npass,
			 clustid,&error,&ifound);
		dist=DistNode(clustid,distMatrix);
//
		MatrixDivide(ncluster,rank,clustid,
			     OldId,NewId,distMatrix,kMatrix,krank);
//
//Go to left branch
		left=true;
 		int* Id;
 		Id=new int [krank[k]];
 		int i;
 		for(i=0;i<krank[k];++i)
 		    Id[i]=NewId[k][i];		
		treekmedoid(krank[k],npass,kMatrix[k],Id,dist,nodes);
//		cout << "ICI" << endl;
	    }else{
		++k;
		if(!finished){//next time in this node
		    if(k>=(ncluster-1))
			finished=true;//all branches processed
//
//Go to right branch
		    left=false;
		    int* Id;
		    Id=new int [krank[k]];
		    int i;
		    for(i=0;i<krank[k];++i)
			Id[i]=NewId[k][i];
		    treekmedoid(krank[k],npass,kMatrix[k],Id,dist,nodes);
		    if(finished){
//		      cout << "finis1 " << prev_node.size()-2 << endl;
		      nodes[prev_node[prev_node.size()-2]].distance=dist_old;
//		      cout << "OK" << endl;
		    };
		};
	    };
	}else{//node is a leaf
	    if(left){
//	      if(curr_node==17)
//		cout << "Left" << endl;
		if(prev_node.back()>0)
		  nodes[prev_node.back()].left=OldId[0];
	    }else{
//	      if(curr_node==17)
//		cout << "Right " << prev_node.back() << endl;
	      if(prev_node.back()>0){
		  nodes[prev_node.back()].right=OldId[0];
		  nodes[prev_node.back()].distance=0.0;
	      };
	    };
	    prev_node.push_back(curr_node-1);//just get something pop
	    nodes[prev_node[prev_node.size()-2]].distance=dist_old;
	    finished=true;
	};
    };
//
//    cout << "sze " << prev_node.size() << endl;
    prev_node.pop_back();
//    cout << "sze2 " << prev_node.size() << " "
//	 << krank[0] << " " << krank[1] << " "
//	 << endl;
//
    return;
};
/***********************************************************/
