#include <iostream>
#include <iomanip>
#include <fstream>
#include <string>
#include <vector>
#include <map>
#include "T2CInOut.hpp"
#include "Cluster2TreeView.hpp"
extern "C"{
#include "cluster.h"
}
using namespace std;

const int MAXNODES=1000;

int main(int argc, char *argv[]){
//
  vector<string> NodeNames;
  string NexusFileName,OutFileName,Nexus;
  int Lvl,nrows;
  int cluid[MAXNODES];
  Node *treenodes;
  treenodes= new Node [MAXNODES];
  ofstream OutFile;
//
  welcome();
  UserInterface(argc,argv,NexusFileName,Lvl,OutFileName);
  NexusFileIn(NodeNames,NexusFileName,Nexus);
  NexusTreeIn(Nexus,treenodes,nrows);
  int itmp1, itmp2;
  double d;
  for(int i=0; i<ceil(double(nrows-1)/2);i++){
    //Output of NexusTreeIn is in reverse order compared to
    //what cuttree function expects
      itmp1=treenodes[i].left;
      itmp2=treenodes[nrows-2-i].left;
      if(itmp1<0)
	itmp1=-(nrows-1-(-itmp1-1));
      if(itmp2<0)
	itmp2=-(nrows-1-(-itmp2-1));
      treenodes[i].left=itmp2;
      treenodes[nrows-2-i].left=itmp1;
//      
      itmp1=treenodes[i].right;
      itmp2=treenodes[nrows-2-i].right;
      if(itmp1<0)
	itmp1=-(nrows-1-(-itmp1-1));
      if(itmp2<0)
	itmp2=-(nrows-1-(-itmp2-1));
      treenodes[i].right=itmp2;
      treenodes[nrows-2-i].right=itmp1;
//
      d=treenodes[i].distance;
      treenodes[i].distance=treenodes[nrows-2-i].distance;
      treenodes[i-2-1].distance=d;
//
  };
  cuttree(nrows,treenodes,Lvl,cluid);
  treenodes=NULL;
  cout << "Clusters list:" << endl;
  OutFile.open(OutFileName.c_str());
  for(int i=0;i<nrows;i++){
    cout << NodeNames[i] << "\t" << cluid[i] << endl;
    OutFile << NodeNames[i] << "\t" << cluid[i] << endl;
  };
  OutFile.close();
  return(0);
};

/* ******************************************************************** */
/* I reproduce here the body of the fonction cuttree since for an       */
/* unknown reason, gcc will not link with cuttree definition in         */
/* cluster.o... Untill I find a better solution.                        */
/*                                                          G. Marcou   */
/* ******************************************************************** */

void cuttree (int nelements, Node* tree, int nclusters, int clusterid[])

/*
Purpose
=======

The cuttree routine takes the output of a hierarchical clustering routine, and
divides the elements in the tree structure into clusters based on the
hierarchical clustering result. The number of clusters is specified by the user.

Arguments
=========

nelements      (input) int
The number of elements that were clustered.

tree           (input) Node[nelements-1]
The clustering solution. Each node in the array describes one linking event,
with tree[i].left and tree[i].right representig the elements that were joined.
The original elements are numbered 0..nelements-1, nodes are numbered
-1..-(nelements-1).

nclusters      (input) int
The number of clusters to be formed.

clusterid      (output) int[nelements]
The number of the cluster to which each element was assigned. Space for this
array should be allocated before calling the cuttree routine. If a memory
error occured, all elements in clusterid are set to -1.

========================================================================
*/
{ int i, j, k;
  int icluster = 0;
  const int n = nelements-nclusters; /* number of nodes to join */
  int* nodeid;
  for (i = nelements-2; i >= n; i--)
  { k = tree[i].left;
    if (k>=0)
    { clusterid[k] = icluster;
      icluster++;
    }
    k = tree[i].right;
    if (k>=0)
    { clusterid[k] = icluster;
      icluster++;
    }
  }
//  nodeid = malloc(n*sizeof(int));
  nodeid = new int [n];
  if(!nodeid)
  { for (i = 0; i < nelements; i++) clusterid[i] = -1;
    return;
  }
  for (i = 0; i < n; i++) nodeid[i] = -1;
  for (i = n-1; i >= 0; i--)
  { if(nodeid[i]<0) 
    { j = icluster;
      nodeid[i] = j;
      icluster++;
    }
    else j = nodeid[i];
    k = tree[i].left;
    if (k<0) nodeid[-k-1] = j; else clusterid[k] = j;
    k = tree[i].right;
    if (k<0) nodeid[-k-1] = j; else clusterid[k] = j;
  }
//  free(nodeid);
  delete nodeid;
  return;
}

