#include "SmlstRng.hpp"
#include <iomanip>
/****************************************************/
SmlstRng::SmlstRng(){//Constructor
    ring.Clear();
    CntRng=0;
    found=false;
};
/****************************************************/
void SmlstRng::Reset(){//Reset private members
    ring.Clear();
    CntRng=0;
    found=false;
    return;
};
/****************************************************/
void SmlstRng::SetSearch(OEAtomBase &atom){//Setting the search for an atom
    MaxCnt=3;
    while(!OEAtomIsInAromaticRingSize(atom,MaxCnt)){
	MaxCnt++;
    }; MaxCnt++;
//    MaxCnt=OEAtomGetSmallestRingSize(atom)+1;
    SeekId=atom.GetIdx();
    return;
};
/****************************************************/
bool SmlstRng::FndARng(OEAtomBase *atom, unsigned int PrevId){
/****************************************************/
/* This method identifies the aromatic ring an atom */
/* belong to. This is a recursive function. It      */
/* follows aromatic bonds from *atom to itself      */
/* PrevId being the Id of the previously passed     */
/* atom. It must be initialized to atom->GetIdx().  */
/* G. Marcou                                        */
/****************************************************/
//
    OEIter<OEAtomBase> _BndAtom;//Bounded atom
    OEAtomBase* LstAt;//Last atom added to the ring
//
    LstAt=0;
    ++CntRng;
//
    if((atom->GetIdx()==SeekId)&&(CntRng>=3))//Is this atom the seeked one?
	found=true;
    if(found)
	return(found);
//
    if((CntRng>=MaxCnt)&&(!found)){//Is the ring size limit was reached?
	found=false;
    };
//
    if((!found)&&(atom->GetIdx()==PrevId))//This is the first atom
	LstAt=ring.NewAtom(*atom);//add it to ring
//If not this a new atom to parse
//
//Atoms cannot be reversed parsed and must be aromatic
    _BndAtom=atom->GetAtoms(!OEHasAtomIdx(PrevId)&&OEIsAromaticAtom());
    if((_BndAtom)&&(CntRng<MaxCnt)&&(!found))//if this is a valid adress
	LstAt=ring.NewAtom(*_BndAtom);//add it to ring
//
/* continue exploring connected atoms untill the ring was complete or
   the _BndAtom adress is no longer valid or the maximum ring size was
   reached */
    while((!found)&&(_BndAtom)&&(CntRng<MaxCnt)){
	found=FndARng(_BndAtom, atom->GetIdx());
 	if(!found){//this atom is not in the seeked ring
 	    ring.DeleteAtom(LstAt);
 	    --CntRng;
 	};
	++_BndAtom;
	if((_BndAtom)&&(CntRng<MaxCnt)&&(!found))//if this is a valid adress
	    LstAt=ring.NewAtom(*_BndAtom);//add it to ring
    };
//
    return(found);
}; 
/****************************************************/
void SmlstRng::CleanRng(){
/****************************************************/
/* The first and last atom of a seeked ring is the  */
/* same. This method delete the last one.           */
/* G. Marcou                                        */
/****************************************************/
//
    OEIter<OEAtomBase> LstAt;
    LstAt=ring.GetAtoms();
    LstAt.ToLast();
    ring.DeleteAtom(LstAt);
//
    return;
};
/****************************************************/
void SmlstRng::RngGC(double GC[3]){
/****************************************************/
/* Find the geometric center of the ring.           */
/* G. Marcou                                        */
/****************************************************/
    int i,N;
    double XYZ[3];
    OEIter<OEAtomBase> OEA; 
    for(i=0;i<3;++i)
	GC[i]=0;
    N=0;
    for(OEA=SmlstRng::ring.GetAtoms();OEA;++OEA){
	++N;
	SmlstRng::ring.GetCoords(OEA,XYZ);
	for(i=0;i<3;++i)
	    GC[i]+=XYZ[i];
    };
    for(i=0;i<3;++i)
	GC[i]=GC[i]/N;
    return;
};
/****************************************************/
void SmlstRng::RngNml(double GC[3], double dir[3]){
/****************************************************/
/* Find the Normal to the ring. Evaluate the        */
/* Geometric Center also.                           */
/* G. Marcou                                        */
/****************************************************/
    int i;
    double U0[3],U1[3],V0[3],V1[3];
    double XYZ0[3],XYZ1[3];
    OEIter<OEAtomBase> OEA0,OEA1; 
//
    SmlstRng::RngGC(GC);
//
    OEA0=SmlstRng::ring.GetAtoms();
    SmlstRng::ring.GetCoords(OEA0,XYZ0);
    OEA1=(++OEA0);
    SmlstRng::ring.GetCoords(OEA1,XYZ1);
    OEGeom3DSubtract(U0,XYZ0,GC);
    OEGeom3DSubtract(U1,XYZ1,GC);        
    OEGeom3DCrossProd(V0,U0,U1);
    OEGeom3DNormalize(V0);
    for(i=0;i<3;++i) dir[i]=V0[i];
//
    for(OEA0=SmlstRng::ring.GetAtoms();OEA1;++OEA0,++OEA1){
	SmlstRng::ring.GetCoords(OEA0,XYZ0);
	SmlstRng::ring.GetCoords(OEA1,XYZ1);
	OEGeom3DSubtract(U0,XYZ0,GC);
	OEGeom3DSubtract(U1,XYZ1,GC);        
	OEGeom3DCrossProd(V1,U0,U1);
	OEGeom3DNormalize(V1);
	if(OEGeom3DDotProd(V0,V1)<0)
	    for(i=0;i<3;++i) V1[i]=-V1[i];
	for(i=0;i<3;++i) dir[i]+=V1[i];
    };
    OEGeom3DNormalize(dir);
//DEBUG
//     cout.setf(ios::fixed);
//     cout.setf(ios::showpoint);
//     cout.precision(6);
//     cout << "     2" << ring.GetTitle() << endl;
//     cout << "   3     0 0     0 0     0 0     0 0     0 0     0 0   " << setw(9) << GC[0] <<"   "<< setw(9) << GC[1] <<"   "<< setw(9) << GC[2] <<"     4!A   2  0.00000  0.00000" << endl;
//     cout << "   3     0 0     0 0     0 0     0 0     0 0     0 0   " << setw(9) << GC[0]+dir[0] <<"   "<< setw(9) << GC[1]+dir[1] <<"   "<< setw(9) << GC[2]+dir[2] <<"     4!A   2  0.00000  0.00000" << endl;
//DEBUG
//
    return;
};
