#include <iostream>
#include <iomanip>
#include <fstream>
#include <string>
#include <vector>
#include <map>
#include "oechem.h"
#include "oesystem.h"
#include "AFP.hpp"
#include "MFP.hpp"
#include "SVMBV.hpp"
#include "SmlstRng.hpp"
#include "SVMInOut.hpp"
#include "treemedoid.hpp"
#include "Cluster2TreeView.hpp"
extern "C"{
#include "cluster.h"
}
using namespace OEChem;
using namespace OEMath;
using namespace OESystem;
using namespace std;

int main(int argc, char *argv[]){
//
    OEMol lig,cav;
    OEIter<OEAtomBase> ligat,cavat;
    oemolistream ims;
//
    string BVstring,allBV;
    istringstream is_BV;
//
    vector<string> ListRef,ListEle;
//
    double rclasses;
    vector<double> classes;
    vector<OEBitVector> BVTrain;
    SVM svm;
    svm_parameter param;
// User interface
    string CavFile,RefListNme,FileListNme,LigFile,OutName;
    string RefNme,s_BV;
    bool BitVector;
//
    welcome();
//
    int err;
    err=0;
    err=UserInterface(argc,argv,CavFile,RefListNme,FileListNme,OutName,
		      BitVector,param);
    if(err) return 1;
//
    svm.SetSVMParameter(param);
// Setting the cavity
    ims.SetFormat(OEFormat::MOL2);
    if(!ims.open(CavFile.c_str())){
	cout << "************main Error***********"<< endl;
	cout << "File " << CavFile << " does not exists!" << endl;
	cout << "*********************************"<< endl;
	return 1;
    };
    ims >> cav;
    ims.close();
//    
    if (OEHasResidues(cav))
    {
	OEPDBOrderAtoms(cav);
    }
    else OEPerceiveResidues(cav);
//
    MFP CavLig(cav);
//
// Train the SVM
    ifstream RefList(RefListNme.c_str());
    if(!RefList){
	cout << "************main Error***********"<< endl;
	cout << "File " << RefListNme << " does not exists!" << endl;
	cout << "*********************************"<< endl;
	return 1;
    };
//
    if(!BitVector){
	RefList >> LigFile  >> rclasses;
	while(RefList){//process sequencially the ligand files stored
	    cout << "Processing " << LigFile
		 << " Activity: " << rclasses <<endl;
	    ims.SetFormat(OEFormat::MOL2);
	    if(!ims.open(LigFile.c_str())){
		cout << "********main loop Warning********"<< endl;
		cout << "Ligand file " << LigFile << " does not exists!" << endl;
		cout << "*********************************"<< endl;
		RefList >> LigFile >> rclasses;
		continue ;
	    };
	    while(ims >> lig){
//
		LigFile=lig.GetTitle();
		cout << "Title: " << LigFile << endl;
		ListEle.push_back(LigFile);
//
		CavLig.ResetIMolFP();
//	CavLig.SetCav(cav);
		CavLig.SetIMolFP(lig);
//
		cout << CavLig << endl;
		BVTrain.push_back(CavLig.GetIMolFP());
		classes.push_back(rclasses);
	    };
	    ims.close();
	    RefList >> LigFile >> rclasses;
	};//All files have been processed
    } else {
	RefList >> RefNme >> s_BV >> rclasses;
	while(RefList){//process sequencially the ligand files stored
	    CavLig.ResetIMolFP();
	    is_BV.clear();
	    is_BV.str(s_BV);
	    ListRef.push_back(RefNme);
	    is_BV >> CavLig;
	    BVTrain.push_back(CavLig.GetIMolFP());
	    classes.push_back(rclasses);
	    RefList >> RefNme >> s_BV >> rclasses;
	};
    };
    RefList.close();
//
    svm.SetBVTrain(BVTrain);
//    svm.SetClasses(classes);
    svm.Training(BVTrain,classes);
    svm.SetModel();
//
// Infere unknown ligand poses affinity
    ifstream FileList(FileListNme.c_str());
    ofstream FileOut(OutName.c_str());
    if(!FileList){
	cout << "************main Error***********"<< endl;
	cout << "File " << FileListNme << " does not exists!" << endl;
	cout << "*********************************"<< endl;
	return 1;
    };
//
    FileList >> LigFile;
    double Scr;
    while(FileList){//process sequencially the ligand files stored
	ims.SetFormat(OEFormat::MOL2);
	if(!ims.open(LigFile.c_str())){
	    cout << "********main loop Warning********"<< endl;
	    cout << "Ligand file " << LigFile << " does not exists!" << endl;
	    cout << "*********************************"<< endl;
	    FileList >> LigFile;
	    continue ;
	};
	while(ims >> lig){
//
	    LigFile=lig.GetTitle();
	    cout << "Title: " << LigFile << endl;
	    ListEle.push_back(LigFile);
//
	    CavLig.ResetIMolFP();
	    CavLig.SetIMolFP(lig);
//
	    cout << CavLig;
	    Scr=svm.Predict(CavLig.GetIMolFP());
	    cout << "SVM Score: "
		 << setprecision(2) << setw(8) << Scr << endl;
	    cout << endl;
	    FileOut << LigFile << " " << Scr << endl;
	};
	ims.close();
	FileList >> LigFile;
    };//All files have been processed
//
    FileList.close();
//
    cout << "Fin du programme" << endl;
//
    return(0);
};

