#include "SVMBV.hpp"
SVM::SVM(){
    SVM::param.svm_type = C_SVC;
    SVM::param.kernel_type = RBF;
    SVM::param.degree = 3;
    SVM::param.gamma = 0;	// 1/k
    SVM::param.coef0 = 0;
    SVM::param.nu = 0.5;
    SVM::param.cache_size = 100;
    SVM::param.C = 1;
    SVM::param.eps = 1e-3;
    SVM::param.p = 0.1;
    SVM::param.shrinking = 1;
    SVM::param.probability = 0;
    SVM::param.nr_weight = 0;
    SVM::param.weight_label = NULL;
    SVM::param.weight = NULL;
    SVM::TrngSze=0;
};
SVM::~SVM(){
    delete &SVM::TrngSze;
    delete SVM::node_space;
    svm_destroy_model(SVM::model);
    svm_destroy_param(&this->param);
    delete SVM::problem.y;
    delete SVM::problem.x;
    return;
};
void SVM::Reset(){
    SVM::TrngSze=0;
};
void SVM::Training(vector<OEBitVector>& BV, vector<double>& tag){
/************************************************************/
/* Train the SVM                                            */
/* G. Marcou                                                */
/************************************************************/
    svm_node node;
    vector<svm_node> BVnodes;
    vector<OEBitVector>::iterator _BVTrain,_BV;
    vector<double>::iterator _tag;
    unsigned int i;
//
    if(BV.size()!=tag.size()){
	cout << "******************Error Training****************" << endl;
	cout << "Bit vectors not as numerous as tags " << endl;
	cout << "******************Error Training****************" << endl;
	exit(1);
    };
//
    SVM::classes.clear();
    for(_tag=tag.begin(), _BV=BV.begin();
 	_tag!=tag.end(), _BV!=BV.end();
 	_tag++, _BV++){
//
	SVM::TrngSze++;
//
 	for(i=0, _BVTrain=SVM::BVTrain.begin();
 	    _BVTrain!=SVM::BVTrain.end();
 	    i++, _BVTrain++){
	    node.index=i;
	    node.value=OETanimoto(*_BV,*_BVTrain);
	    BVnodes.push_back(node);
	};
	node.index=-1;
	node.value=-1.0;
	BVnodes.push_back(node);
	SVM::nodes.push_back(BVnodes);
	BVnodes.clear();
//
 	SVM::classes.push_back(*_tag);
    };
//
    return;
};
/************************************************************/
void SVM::SetModel(){
/************************************************************/
/* Set the SVM model                                        */
/* G. Marcou                                                */
/************************************************************/
    if(int(SVM::classes.size())!=SVM::TrngSze){
 	cout << "******************Error SetModel****************" << endl;
 	cout << "SVM classes size different than training set size" << endl;
 	cout << "******************Error Training****************" << endl;
 	cout << SVM::classes.size() << " " << SVM::TrngSze << endl;
 	exit(1);
    };
    SVM::problem.l=SVM::TrngSze;
    SVM::problem.y=new double[SVM::TrngSze];
    SVM::problem.x=new svm_node*[SVM::TrngSze];
    int elements=0;
    vector<vector<svm_node> >::iterator _nodes;
    for(_nodes=SVM::nodes.begin();_nodes!=SVM::nodes.end();_nodes++)
	elements+=_nodes->size();
    SVM::node_space=new svm_node[elements];
    unsigned int j=0;
    unsigned int i=0;
    for(_nodes=SVM::nodes.begin();
	_nodes!=SVM::nodes.end();_nodes++, i++){
	vector<svm_node> BVnodes=*_nodes;
	vector<svm_node>::iterator _BVnodes;
	SVM::problem.x[i]=&SVM::node_space[j];
	for(_BVnodes=BVnodes.begin();_BVnodes!=BVnodes.end();_BVnodes++){
	    SVM::node_space[j]=*_BVnodes;
	    ++j;
	};
    };
    vector<double>::iterator _classes;
    for(j=0, _classes=SVM::classes.begin();
	_classes!=SVM::classes.end();j++, _classes++){
	SVM::problem.y[j]=*_classes;
    };
//
    cout << "Preparing the model" << endl;
    SVM::model=svm_train(&this->problem ,&this->param);
    cout << "model done" << endl;
//
    return;
};
/************************************************************/
double SVM::Predict(OEBitVector BV){
/************************************************************/
/* Uses the SVM model to do predictions                     */
/* G. Marcou                                                */
/************************************************************/
    svm_node nodes[SVM::BVTrain.size()+1];
    vector<OEBitVector>::iterator _BVTrain;
    unsigned int i;
    cout << "Tanimoto: ";
    for(i=0, _BVTrain=SVM::BVTrain.begin();
	_BVTrain!=SVM::BVTrain.end();
	++i, _BVTrain++){
	nodes[i].index=i;
	nodes[i].value=OETanimoto(*_BVTrain,BV);
	cout << nodes[i].value << " ";
    };
    nodes[i].value=-1; nodes[i].index=-1;
    cout << endl;
    return(svm_predict(SVM::model,nodes));
};
