#ifndef MYMFP_HPP
#define MYMFP_HPP
#include "MFP.hpp"
#include "MyAFP.hpp"
using namespace OEChem;
using namespace OESystem;
using namespace std;

class MyMFP:public MFP{
/****************************************************/
/* Molecular Interaction Finger Print.              */
/* G. Marcou                                        */
/****************************************************/
public:
    MyMFP(){
	AFP::SetTopPrime(20);
	MFP::SetResBVSize(MyAFP::GetBitNbre());    
	cout << "Top Prime: " << AFP::GetTopPrime() << endl;
	cout << " Residue Bit Vector Size: " << MFP::GetResBVSize() << endl;
    };
    MyMFP(OEMol &mol):MFP(mol){
	AFP::SetTopPrime(20);
	MFP::SetResBVSize(MyAFP::GetBitNbre());    
	cout << "Top Prime: " << AFP::GetTopPrime() << endl;
	cout << " Residue Bit Vector Size: " << MFP::GetResBVSize() << endl;
    };
    void SetIMolFP(OEMol &lig);
private:
};
//
inline ostream& operator << (ostream &strm, MyMFP &MolFP){
    int i,iprnt;
    OEBitVector OEBV;
//
    map<string,int> BVPos;
    map<string,int>::iterator _BVPos;
    BVPos=MolFP.GetResBVPos();
    for(i=0;i<int(BVPos.size());++i){
//Print residue references in same order as the OEBitVector
      _BVPos=BVPos.begin();
      while((_BVPos!=BVPos.end())&&(_BVPos->second!=int(i)))
	_BVPos++;
      strm << "|" << setw (MolFP.GetResBVSize()-1) << _BVPos->first;
    };
    strm << endl;
//
//Display the OEBitVector
    OEBV=MolFP.GetIMolFP();
    for(iprnt=0;iprnt<int(OEBV.GetSize());++iprnt)
	strm << OEBV.IsBitOn(iprnt);
    strm << endl;
    return(strm);
};
#endif
