#include "MyMFP.hpp"
/****************************************************/
void MyMFP::SetIMolFP(OEMol &lig){
/****************************************************/
/* Set the Molecular Interaction Finger Print based */
/* on a cavity OEMol and ligand OEMol.              */
/* G. Marcou                                        */
/****************************************************/
    OEMol cav;
    OEIter<OEAtomBase> ligat,cavat;
    OEResidue cavres;
//
    MyAFP cavFP,ligFP;//atomic finger prints
    map<string,int> ResBVPos;
    map<int,int> NbrePrem;//Map Res. to pos. in MFP, Nbre. Premiers 
    map<string,int>::iterator _ResBVPos;
    map<int,int>::iterator _NbrePrem;
//vector of RFP, vector of MFP: multi-molecule finger print
    vector<OEBitVector> VRFP;
    vector<OEBitVector>::iterator _VRFP;
    OEBitVector IMolFP;
    string SResID;//strings for OEBitVector to Hex conversion
    int inter; //interaction identifier
//
// Prime number inter. code to residue finger print inter. code map init.
    NbrePrem=AFP::GetPrimNbre();
    MFP::SetResBVSize(MyAFP::GetBitNbre());
    OEBitVector RFP(MFP::GetResBVSize());//Residue finger print
//
    cav=MFP::GetCav();
//Initialize ResBVPos if needed and VRFP
    ResBVPos=MFP::GetResBVPos();
    if(ResBVPos.size()==0){
	MFP::InitResBVPos();
	ResBVPos=MFP::GetResBVPos();
    };
    for(_ResBVPos=ResBVPos.begin();_ResBVPos!=ResBVPos.end();++_ResBVPos){
	RFP.ClearBits();
	VRFP.push_back(RFP);
    };
//
    for(cavat=cav.GetAtoms();cavat;++cavat){
// Choose the residue finger print related to cavat
        cavres = OEAtomGetResidue(cavat);
        ostringstream Snum;
	Snum << cavres.GetResidueNumber();
	SResID=cavres.GetChainID()+Snum.str()+cavres.GetName();
//SResID identifies residues by ChainID, number, and Name
	_ResBVPos=ResBVPos.find(SResID);
	RFP=VRFP[_ResBVPos->second];
//
	cavFP.PropReset();
	cavFP.SetProperties(cav,cavat);
	cavFP.SetDirections(cav,cavat);//Set cavity atom finger print
	for(ligat=lig.GetAtoms();ligat;++ligat){
	    ligFP.PropReset();
	    ligFP.SetProperties(lig,ligat);
	    ligFP.SetDirections(lig,ligat);//Set ligand atom finger print
//
	    inter=cavFP+ligFP;//Get the characteristic int. of the inter.
// //DEBUG
// 	    bool print=false;
// 	    if(inter!=1){
// 		print=true;
// 		cout << cavres.GetName() << " "
// 		     << SResID << " "
// 		     << ligat->GetName() << " "
// 		     << inter << " ";
// 	    };
// //DEBUG
	    while(inter!=1)//There's an inter. between cavat & ligat
//Transpose the characteristic int. in RFP bit position
		for(_NbrePrem=NbrePrem.begin();
		    _NbrePrem!=NbrePrem.end();++_NbrePrem)
		    if(inter%_NbrePrem->second==0){
			RFP.SetBitOn(unsigned(_NbrePrem->first));
			inter=inter/_NbrePrem->second;
		    };
	};
	//Average the interactions over the residue
//replace the old finger print
	VRFP[_ResBVPos->second]=RFP;
    };
//From VRFP vector to MFP
    unsigned int sze=0;
    for(_VRFP=VRFP.begin();_VRFP!=VRFP.end();++_VRFP){
	for(unsigned int i=0; i<_VRFP->GetSize(); ++i, ++sze){
	    if(_VRFP->IsBitOn(i))
		IMolFP.SetBitOn(sze);
	};
	if(IMolFP.GetSize()<sze)
	    IMolFP.SetBitOff(sze-1);
    };
//
    MFP::SetIMolFP(IMolFP);
//
    return;
};
