#ifndef MFP_HPP
#define MFP_HPP
#include <ostream>
#include <iomanip>
#include <algorithm>
#include "AFP.hpp"
#include "misc.hpp"
#include "oechem.h"
#include "oesystem.h"
using namespace OEChem;
using namespace OESystem;
using namespace std;

class MFP{
/****************************************************/
/* Molecular Interaction Finger Print.              */
/* G. Marcou                                        */
/****************************************************/
public:
    MFP();
    MFP(OEMol &mol);
    void InitResBVPos();
    inline void SetIMolFP(OEBitVector &OEBV){
	if(MFP::ResBVPos.size()==0)
	    MFP::InitResBVPos();
	MFP::IMolFP=OEBV;
	return;
    };
    inline void SetIMolFP(OEBitVector &OEBV, unsigned int sze){
	if(MFP::ResBVPos.size()==0)
	    MFP::InitResBVPos();
	MFP::IMolFP=OEBV;
	MFP::IMolFP.SetSize(sze);
	return;
    };
    void SetIMolFP(OEMol &lig);
    inline void IMolFPClear(){
      MFP::IMolFP.SetSize(0);
      return;
    }
    inline void SetCav(OEMol &mol){
	MFP::cav=mol;
	return;
    };
    inline OEMol GetCav(){
	return(MFP::cav);
    };
    inline OEBitVector GetIMolFP(){
	return(MFP::IMolFP);
    };
    inline void ResetResBVPos(){
	MFP::ResBVPos.clear();
    };
    inline void ResetIMolFP(){
	MFP::IMolFP.ClearBits();
    };
    inline map<string,int> GetResBVPos(){
      return(MFP::ResBVPos);
    };
    inline void SetResBVSize(unsigned int i){
	MFP::ResBVSize=i;
	return;
    };
    inline int GetResBVSize(){
	return(MFP::ResBVSize);
    };
private:
    map<string,int> ResBVPos;//Map Res. to pos. in IMolFP
    OEMol cav;//Cavity bounded to the Interaction Finger Print
    OEBitVector IMolFP;//OEBitVector of the Finger Print
    static unsigned int ResBVSize;//Bit vector size per residue
};
//
inline ostream& operator << (ostream &strm, MFP &MolFP){
    int i,iprnt;
    OEBitVector OEBV;
//
    map<string,int> BVPos;
    map<string,int>::iterator _BVPos;
    BVPos=MolFP.GetResBVPos();
    for(i=0;i<int(BVPos.size());++i){
//Print residue references in same order as the OEBitVector
      _BVPos=BVPos.begin();
      while((_BVPos!=BVPos.end())&&(_BVPos->second!=int(i)))
	_BVPos++;
      strm << "|" << setw (MolFP.GetResBVSize()-1) << _BVPos->first;// << "|";
    };
    strm << endl;
//
//Display the OEBitVector
    OEBV=MolFP.GetIMolFP();
    for(iprnt=0;iprnt<int(OEBV.GetSize());++iprnt)
	strm << OEBV.IsBitOn(iprnt);
    strm << endl;
    return(strm);
};
//
inline istream& operator >> (istream &strm, MFP &MolFP){
    int i;
    char c;
    OEBitVector OEBV;
//
    if(!strm.good()) return(strm);
    c='x';
    i=0;
    while((c!='\n')&&(strm.good())){
	c=strm.get();
	if(c=='0'){
	    OEBV.SetBitOff(i);
	    i++;
	} else if(c=='1'){
	    OEBV.SetBitOn(i);
	    i++;
	};
    };
    MolFP.SetIMolFP(OEBV);
//
    return(strm);
};
#endif
