#include "MAFP.hpp"
unsigned int MAFP::AtmBVSize=0;
//
MAFP::MAFP(OEMol &mol){
    MAFP::lig=mol;
    MAFP::SetAtmBVSize(AFP::GetBitNbre());
    cout << "Top Prime: " << AFP::GetTopPrime() << endl;
    cout << "Atom Bit Vector Size: " << MAFP::GetAtmBVSize() << endl;
};
/****************************************************/
void MAFP::InitAtmBVPos(){
/****************************************************/
/* Initialize the atom index to position in the     */
/* BitVector vector.                                */
/* G. Marcou                                        */
/****************************************************/
    OEIter<OEAtomBase> ligat;
    string SAtmID;
    map<string,int>::iterator _AtmBVPos;
    int AtmCpt;
//
    AtmCpt=0;//Atom counting, index in MAFP vector
    for(ligat=MAFP::lig.GetAtoms();ligat;++ligat){
        ostringstream Snum;
	Snum << ligat->GetIdx();
	SAtmID=ligat->GetType()+Snum.str();
//SAtmID identifies Atoms by type and OEId number
	MAFP::AtmBVPos[SAtmID]=AtmCpt;//init. the AtmBVPos map.
	++AtmCpt;
    };
//
    return;
};
/****************************************************/
void MAFP::SetIMolFP(OEMol &cav){
/****************************************************/
/* Set the Molecular Interaction Finger Print based */
/* on a cavity OEMol and ligand OEMol.              */
/* G. Marcou                                        */
/****************************************************/
    OEIter<OEAtomBase> ligat,cavat;
//
    AFP cavFP,ligFP;//atomic finger prints
    map<int,int> NbrePrem;//Map Res. to pos. in MAFP, Nbre. Premiers 
    map<string,int>::iterator _AtmBVPos;
    map<int,int>::iterator _NbrePrem;
//vector of AFP, vector of MAFP: multi-molecule finger print
    vector<OEBitVector> VAFP;
    vector<OEBitVector>::iterator _VAFP;
    string SAtmID;//strings for OEBitVector to Hex conversion
    int inter; //interaction identifier
//
// Prime number inter. code to atom finger print inter. code map init.
    NbrePrem=AFP::GetPrimNbre();
    MAFP::SetAtmBVSize(AFP::GetBitNbre());
    OEBitVector AFP(MAFP::GetAtmBVSize());//Ligand atom finger print
//
//Initialize AtmBVPos if needed and VAFP
    if(MAFP::AtmBVPos.size()==0)
	InitAtmBVPos();
    for(_AtmBVPos=MAFP::AtmBVPos.begin();
	_AtmBVPos!=MAFP::AtmBVPos.end();
	++_AtmBVPos){
	AFP.ClearBits();
	VAFP.push_back(AFP);
    };
//
    for(ligat=MAFP::lig.GetAtoms();ligat;++ligat){
// Choose the atom finger print related to cavat
        ostringstream Snum;
	Snum << ligat->GetIdx();
	SAtmID=ligat->GetType()+Snum.str();
//SResID identifies residues by ChainID, number, and Name
	_AtmBVPos=MAFP::AtmBVPos.find(SAtmID);
	AFP=VAFP[_AtmBVPos->second];
//
	ligFP.PropReset();
	ligFP.SetProperties(ligat);
	ligFP.SetDirections(MAFP::lig,ligat);//Set cavity atom finger print
	for(cavat=cav.GetAtoms();cavat;++cavat){
	    cavFP.PropReset();
	    cavFP.SetProperties(cavat);
	    cavFP.SetDirections(cav,cavat);//Set ligand atom finger print
//
	    inter=cavFP+ligFP;//Get the characteristic int. of the inter.
// //DEBUG
// 	    bool print=false;
//	    if(inter!=1){
// 		print=true;
// 		cout << cavres.GetName() << " "
// 		     << SResID << " "
// 		     << ligat->GetName() << " "
// 		     << inter << " ";
// 	    };
// //DEBUG
	    while(inter!=1)//There's an inter. between cavat & ligat
//Transpose the characteristic int. in RFP bit position
		for(_NbrePrem=NbrePrem.begin();
		    _NbrePrem!=NbrePrem.end();++_NbrePrem)
		    if(inter%_NbrePrem->second==0){
			AFP.SetBitOn(unsigned(_NbrePrem->first));
			inter=inter/_NbrePrem->second;
		    };
// //DEBUG
// 	    if(print){
// 		RFP.ToHexString(BVstring);
//		cout << BVstring << endl;
// 	    }; 
// //DEBUG
	};
	//Average the interactions over the residue
//replace the old finger print
	VAFP[_AtmBVPos->second]=AFP;
    };
//From VAFP vector to MAFP
    unsigned int sze=0;
    for(_VAFP=VAFP.begin();_VAFP!=VAFP.end();++_VAFP){
	for(unsigned int i=0; i<_VAFP->GetSize(); ++i, ++sze){
	    if(_VAFP->IsBitOn(i))
		MAFP::IMolFP.SetBitOn(sze);
	};
	if(MAFP::IMolFP.GetSize()<sze)
	    MAFP::IMolFP.SetBitOff(sze-1);
    };
//
    return;
};
