#include "Bayes.hpp"
#include <iomanip>
/************************************************************/
//Constructor
Bayes::Bayes(){
    Bayes::Init=true;
    Bayes::TotAct=0;
    Bayes::TotInAct=0;
    Bayes::NFeature=0;
    Bayes::Algo=0;
};
/************************************************************/
void Bayes::Reset(){
/************************************************************/
/* Reset private class variable.                            */
/* G. Marcou                                                */
/************************************************************/
    Bayes::Init=true;
    Bayes::TotAct=0;
    Bayes::TotInAct=0;
    Bayes::NFeature=0;
    Bayes::Algo=0;
};
/************************************************************/
void Bayes::Training(OEBitVector BV, bool Active){
/************************************************************/
/* Train the learning machine.                              */
/* G. Marcou                                                */
/************************************************************/
    if(Active)
	++TotAct;
    else
	++TotInAct;
//
    if(Bayes::Init){
	Bayes::NFeature=BV.GetSize();
    };
//
    for(unsigned int i=0;i<BV.GetSize();++i){
	if(Bayes::Init){
	    Bayes::OnAct.push_back(0);
	    Bayes::OnInAct.push_back(0);
	    Bayes::OffAct.push_back(0);
	    Bayes::OffInAct.push_back(0);
	};
//
	if(BV.IsBitOn(i)){
	    if(Active)
		Bayes::OnAct[i]++;
	    else
		Bayes::OnInAct[i]++;
	} else {
	    if(Active)
		Bayes::OffAct[i]++;
	    else
		Bayes::OffInAct[i]++;
	};
    };
    Bayes::Init=false;
    return;
};
/************************************************************/
void Bayes::SetSupport(){
/************************************************************/
/* Set the OnSupport and OffSupport vector                  */
/* G. Marcou                                                */
/************************************************************/
    vector<int>::iterator _On,_Off;
    for(_On=Bayes::OnAct.begin(); _On!=Bayes::OnAct.end(); _On++){
      //        cout << *_On << "||";
	OnSupport.push_back(double(*_On)/double(Bayes::TotAct));
    };
    //    cout << endl;
    for(_Off=Bayes::OffAct.begin(); _Off!=Bayes::OffAct.end(); _Off++){
      //      cout << *_Off << "||";
	OffSupport.push_back(double(*_Off)/double(Bayes::TotAct));
    };
    //    cout << endl;
    return;
};
/************************************************************/
void Bayes::SetInfereXiao(){
/************************************************************/
/* Infere bit contribution to Xiao's discriminant function  */
/* G. Marcou                                                */
/************************************************************/
    double Pfinal,TotOn,TotOff,Tot;
    TotOn=0; TotOff=0; Tot=0;
    for(int i=0;i<Bayes::NFeature;++i){
	TotOn=double(Bayes::OnAct[i])+double(Bayes::OnInAct[i]);
	TotOff=double(Bayes::OffAct[i])+double(Bayes::OffInAct[i]);
	Tot=double(Bayes::TotInAct)+double(Bayes::TotAct);
//
	Pfinal=(double(Bayes::OnAct[i])+1)*Tot/
	    (TotOn*double(Bayes::TotAct)+Tot);
	Bayes::OnInfere.push_back(Pfinal);
//
	Pfinal=(double(Bayes::OffAct[i])+1)*Tot/
	    (TotOff*double(Bayes::TotAct)+Tot);
	Bayes::OffInfere.push_back(Pfinal);
    };
    return;
};
/************************************************************/
void Bayes::SetInfereBayes(){
/************************************************************/
/* Infere conditional probabilities for each bit            */
/* G. Marcou                                                */
/************************************************************/
    for(int i=0;i<NFeature;++i){
	double PCond;
//
	if(Bayes::OnAct[i]!=0)
	    PCond=log(double(Bayes::OnAct[i])/
		(double(Bayes::OnAct[i])+double(Bayes::OnInAct[i])));
	else
	    PCond=-10000.0;
	Bayes::OnInfere.push_back(PCond);
//
	if(Bayes::OffAct[i]!=0)
	    PCond=log(double(Bayes::OffAct[i])/
		(double(Bayes::OffAct[i])+double(Bayes::OffInAct[i])));
	else
	    PCond=-10000.0;
	Bayes::OffInfere.push_back(PCond);
    };
    //    for(int i=0;i<NFeature;++i)
    //	cout << setw(4) << Bayes::OnInfere[i] << "|";
    //    cout << endl << endl;
    //    for(int i=0;i<NFeature;++i)
    //	cout << setw(4) << Bayes::OffInfere[i] << "|";
    //    cout << endl << endl;
    this->SetSupport();
//     for(int i=0;i<NFeature;++i)
// 	if((Bayes::OnSupport[i]>Bayes::GetOnSupportMin())&&
// 	   (Bayes::OffSupport[i]>Bayes::GetOffSupportMin()))
// 	  cout << setw(6) << Bayes::OnSupport[i] << " " << setw(6) << Bayes::OffSupport[i] << " "
// 	       << setw(6) << Bayes::OnInfere[i] << " " << setw(6) << Bayes::OffInfere[i] << endl;
//     cout << endl << endl;
    //    for(int i=0;i<NFeature;++i)
    //      cout << setw(4) << Bayes::OffSupport[i] << "|";
    //    cout << endl << endl;
    
    return;
};
/************************************************************/
double Bayes::Predict(OEBitVector BV){
/************************************************************/
/* Evaluate discrininant function/conditional probability   */
/* G. Marcou                                                */
/************************************************************/
    double scr;
    if((Bayes::OnInfere.size()!=BV.GetSize())||
       (Bayes::OffInfere.size()!=BV.GetSize())){
	cout << "OnInfere.size() " << OnInfere.size()
	     << " OffInfere.size() " << OffInfere.size()
	     << " BV.GetSize() "<< BV.GetSize() << endl;
	cout << "**************ERROR: Bayes**************" << endl;
	cout << "Nbre of features not equal nbre of infering weights" << endl;
	cout << "****************************************" << endl;
	exit(1);
    };
    if((Bayes::OnSupport.empty())||(Bayes::OffSupport.empty()))
	this->SetSupport();
    switch(Bayes::GetAlgo()){
	case 0:
	    scr=1.0;
	    break;
	case 1:
	    scr=0.0;
	    break;
	default:
	    cout << "**************ERROR: Bayes**************" << endl;
	    cout << "Algorithm not implemented" << endl;
	    cout << "****************************************" << endl;
	    exit(1);
    };
    for(unsigned int i=0;i<BV.GetSize();++i)
	switch(Bayes::GetAlgo()){
	    case 0:
		if((Bayes::OnSupport[i]>Bayes::OnSupportMin)&&
		   (Bayes::OffSupport[i]>Bayes::OffSupportMin))
		    if(BV.IsBitOn(i)){
			scr+=Bayes::OnInfere[i];
		    } else {
			scr+=Bayes::OffInfere[i];
		    };
		break;
	    case 1:
		if(BV.IsBitOn(i)){
		    scr+=(Bayes::OnInfere[i]>0)?
			log(Bayes::OnInfere[i]):-10000;
		} else {
		    scr+=(Bayes::OffInfere[i]>0)?
			log(Bayes::OffInfere[i]):-10000;
		};
		break;
	    default:
		cout << "**************ERROR: Bayes**************" << endl;
		cout << "Algorithm not implemented" << endl;
		cout << "****************************************" << endl;
		exit(1);
	};
//
    return(scr);
};
