#include "AFP.hpp"
//Static variables
unsigned int AFP::TopPrime=18;
map<int,int> AFP::PrimNbre;
//
bool AFP::LcloRng=false;
double AFP::Hdist=HBDISTA;
double AFP::Hangl=HBANGLE;
double AFP::Hdngl=HBDNGLE;
double AFP::PSdist=FFDISTA;
double AFP::PSangl=FFANGLE;
double AFP::PSdngl=FFDNGLE;
double AFP::EFdist=EFDISTA;
double AFP::EFangl=EFANGLE;
double AFP::EFdngl=EFDNGLE;
double AFP::Hydist=HYDIST;
double AFP::Iondst=IONDST;
/************************************************************/
//Constructor
AFP::AFP(){
//
    AFP::SetPrimNbre();
//
    IsHD=false;
    IsHA=false;
    IsAr=false;
    IsHy=false;
    IsCat=false;
    IsAnn=false;
//
    for(int i=0;i<3;++i){
	HD[i]=0;
	NAro[i]=0;
	HAGC[i]=0;
	HDGC[i]=0;
	IoGC[i]=0;
	AroGC[i]=0;
    };
};
/************************************************************/
//Kind of potential interaction
//Setting
void AFP::SetIsHD(OEAtomBase *X){//Is an H-bond donnor
/************************************************************/
/* An H-bond donor is an hydrogen covalently linked to an   */
/* oxygen or a nitrogen or sulfur                           */
/* G. Marcou                                                */
/************************************************************/
    OEIter<OEAtomBase> Y=X->GetAtoms();
    AFP::IsHD=false;
    if(X->IsHydrogen()&&
       (Y->IsOxygen()||Y->IsNitrogen()||Y->IsSulfur())){
	AFP::IsHD=true;
    };
    return;
};
void AFP::SetIsHA(OEAtomBase *X){//Is an H-bond acceptor
/************************************************************/
/* An H-bond acceptor is any neutral oxygen or nitroge atom */
/* excepted for N.pl3, N.am and N.4 atom types              */
/* G. Marcou (corrected by Nath and Didier)                 */
/************************************************************/
    AFP::IsHA=false;
//
    if(X->GetFormalCharge()<0){
	AFP::IsHA=true;
    } else if(X->GetFormalCharge()==0){
	if (X->IsOxygen()||(X->IsNitrogen()&&(strcmp(X->GetType(),"N.pl3")!=0)
			    &&(strcmp(X->GetType(),"N.am")!=0)
			    &&(strcmp(X->GetType(),"N.4")!=0))){
	  AFP::IsHA=true;
	};
    } else {
	AFP::IsHA=false;
    };
// //
//     int typ=X->GetAtomicNum();
//     if((typ==17)||(typ==9)){//Cl=17, F=9
// 	    AFP::SetIsHA(true);
//     };
    return;
};
void AFP::SetIsHy(OEAtomBase *X){//Is Hydrophobe
/************************************************************/
/* An hydrophobic atom is an hydrogen covalently linked to  */
/* a carbon or carbon alone.                                */
/* G. Marcou                                                */
/************************************************************/
    OEIter<OEAtomBase> Y=X->GetAtoms();
    AFP::IsHy=false;
    if(X->IsCarbon()||X->IsSulfur()){
	AFP::IsHy=true;
    };
    int typ=X->GetAtomicNum();
    if((typ==17)||(typ==9)||(typ==35)||(typ==53)){//Cl=17, F=9, Br=35, I=53
	AFP::IsHy=true;
    };
    return;
};
/************************************************************/
void AFP::SetProperties(OEAtomBase *X){//Set all properties
    AFP::SetIsHA(X);
    AFP::SetIsHD(X);
    AFP::SetIsHy(X);
    AFP::SetIsAr(X);
    AFP::SetIsAnn(X);
    AFP::SetIsCat(X);
    return;
};
/************************************************************/
//Tools
void AFP::PropReset(){
/************************************************************/
/* Reset properties                                         */
/* G. Marcou                                                */
/************************************************************/
    IsHD=false;
    IsHA=false;
    IsAr=false;
    IsHy=false;
    IsCat=false;
    IsAnn=false;
//
    for(int i=0;i<3;++i){
	HD[i]=0;
	NAro[i]=0;
	HAGC[i]=0;
	HDGC[i]=0;
	IoGC[i]=0;
	AroGC[i]=0;
    };
//
    return;
};
/************************************************************/
void AFP::HDFind(OEMolBase &conf, OEAtomBase *OEA_D, OEAtomBase *OEA_H){
/************************************************************/
/* Find the Donor to Hydrogen vector that define the H-bond */
/* donor direction                                          */
/* G. Marcou                                                */
/************************************************************/
    double XYZ_D[3],XYZ_H[3],U[3];
    int i;
//
    conf.GetCoords(OEA_D,XYZ_D);
    conf.GetCoords(OEA_H,XYZ_H);
    for(i=0;i<3;++i) AFP::HDGC[i]=XYZ_D[i];
//
    OEGeom3DSubtract(U,XYZ_H,XYZ_D);
    OEGeom3DNormalize(U);
//
    for(i=0;i<3;i++){
	AFP::HD[i]=U[i];
    };
//
    return;    
};
/************************************************************/
void AFP::HAFind(OEMolBase &conf, OEAtomBase *OEA_A){
/************************************************************/
/* Find the H-bond acceptor center. No directions are fixed.*/
/* G. Marcou                                                */
/************************************************************/
    double XYZ_A[3];
    OEIter<OEAtomBase> OEA_X;    
    int i;
//
    conf.GetCoords(OEA_A,XYZ_A);
    for(i=0;i<3;++i) AFP::HAGC[i]=XYZ_A[i];
//
    return;
};
/************************************************************/
void AFP::NAroFind_Local(OEMolBase &Ring){
/************************************************************/
/* Find the normal to the aromatic ring. Set GC on the      */
/* atom.                                                    */
/* G. Marcou                                                */
/************************************************************/
    OEIter<OEAtomBase> OEA_C1,OEA_C2;    
    double XYZ_C1[3],XYZ_C2[3],U1[3],U2[3],V[3];
    int i;
//
    OEA_C1=Ring.GetAtoms();
    Ring.GetCoords(OEA_C1,AFP::AroGC);
    OEA_C2=Ring.GetAtoms();
    ++OEA_C1;
    ++OEA_C2;
    ++OEA_C2;
    Ring.GetCoords(OEA_C1,XYZ_C1);
    Ring.GetCoords(OEA_C2,XYZ_C2);
    OEGeom3DSubtract(U1,XYZ_C1,AFP::AroGC);
    OEGeom3DSubtract(U2,XYZ_C2,AFP::AroGC);    
    OEGeom3DCrossProd(V,U1,U2);
    OEGeom3DNormalize(V);
//
     for(i=0;i<3;i++){
 	AFP::NAro[i]=V[i];
     };
//
     return;
};
/************************************************************/
void AFP::SetDirections(OEMolBase &mol, OEAtomBase *X){
/************************************************************/
/* Set directions of aromaticity and H-bonds                */
/* G. Marcou                                                */
/************************************************************/
    OEMol ring;
    OEIter<OEAtomBase> near;
    OEIter<OEAtomBase> Y=X->GetAtoms();
    if(AFP::IsHy) AFP::HyFind(mol,X);
    if(AFP::IsAnn||AFP::IsCat) AFP::IonFind(mol,X);
    if(AFP::IsHA) AFP::HAFind(mol,X);
    if(AFP::IsHD) AFP::HDFind(mol,Y,X);
    if(AFP::IsAr){
	if(LcloRng){
	    SmlstRng SR;
	    SR.SetSearch(*X);
	    SR.FndARng(X,X->GetIdx());
	    SR.CleanRng();
	    SR.RngNml(AFP::AroGC,AFP::NAro);
	} else{    
	    ring.NewAtom(*X);
	    for(near=X->GetAtoms(IsAromaticAtom());near;++near)
		ring.NewAtom(*near);
	    AFP::NAroFind_Local(ring);
	};
    };
    return;
};
//Arithmetic
/************************************************************/
int operator + (const AFP &a, const AFP &b){
/************************************************************/
/* Addition operator: given two Atomic Finger Prints, check */
/* what kind of interactions actually exists.               */
/*       1: No interactions                                 */
/*       2: Hydrophobic                                     */
/*       3: Pi stacking                                     */
/*       5: Edge to face                                    */
/*       7: H-bond Donor Acceptor                           */
/*      11: H-bond Acceptor Donor                           */
/*      13: Ionic interaction + -                           */
/*      17: Ionic interaction - +                           */
/* Multiple kind of interactions are given by products:     */
/*    Hydrophobic AND Pi stacking= 3*5                      */
/* G. Marcou                                                */
/************************************************************/
    double U[3];
    double scalar;
    int i,Inter;
    map<int,int> NbrePrem=AFP::GetPrimNbre();
    map<int,int>::iterator _NbrePrem;
    Inter=1;
    _NbrePrem=NbrePrem.begin();
    if(AFP::Hydist>0){
	if(a.IsHy&&b.IsHy)
	    if(OEGeom3DDistance(a.HyGC,b.HyGC)<AFP::Hydist)
		Inter*=_NbrePrem->second;
	_NbrePrem++;
    };
    if(AFP::PSdist>0){
	if(a.IsAr&&b.IsAr){
	    scalar=0;
	    for(i=0;i<3;++i) scalar+=a.NAro[i]*b.NAro[i];
	    scalar=abs(scalar);
	    if(abs(acos(scalar)-AFP::PSangl)<abs(AFP::PSdngl))
		if(AFP::PSdist>0){
		    if(OEGeom3DDistance(a.AroGC,b.AroGC)<AFP::PSdist)
			Inter*=_NbrePrem->second;
		};
	};
	_NbrePrem++;
    };
    if(AFP::EFdist>0){
	if(a.IsAr&&b.IsAr){
	    scalar=0;
	    for(i=0;i<3;++i) scalar+=a.NAro[i]*b.NAro[i];
	    scalar=abs(scalar);
	    if(abs(acos(scalar)-AFP::EFangl)<abs(AFP::EFdngl))
		if(AFP::EFdist>0){
		    if(OEGeom3DDistance(a.AroGC,b.AroGC)<AFP::EFdist)
			Inter*=_NbrePrem->second;
		};
	};
	_NbrePrem++;
    };
    if(AFP::Hdist>0){
	if(a.IsHD&&b.IsHA){
	    OEGeom3DSubtract(U,b.HAGC,a.HDGC);//D-H...A direction
	    OEGeom3DNormalize(U);	
	    scalar=0;
	    for(i=0;i<3;++i) scalar+=a.HD[i]*U[i];
//H-bond geometry control
	    if(abs(acos(scalar)-AFP::Hangl)<abs(AFP::Hdngl))
		if(OEGeom3DDistance(a.HDGC,b.HAGC)<AFP::Hdist)
		    Inter*=_NbrePrem->second;
	};
	_NbrePrem++;
	if(a.IsHA&&b.IsHD){
	    OEGeom3DSubtract(U,a.HAGC,b.HDGC);//D-H...A direction
	    OEGeom3DNormalize(U);	
	    scalar=0;
	    for(i=0;i<3;++i) scalar+=b.HD[i]*U[i];
//H-bond geometry control
	    if(abs(acos(scalar)-AFP::Hangl)<abs(AFP::Hdngl))
		if(OEGeom3DDistance(a.HAGC,b.HDGC)<AFP::Hdist)
		    Inter*=_NbrePrem->second;
	};
	_NbrePrem++;
    };
    if(AFP::Iondst>0){
	if(a.IsCat&&b.IsAnn)
	    if(OEGeom3DDistance(a.IoGC,b.IoGC)<AFP::Iondst)
		Inter*=_NbrePrem->second;
	_NbrePrem++;
	if(a.IsAnn&&b.IsCat&&(AFP::Iondst>0))
	    if(OEGeom3DDistance(a.IoGC,b.IoGC)<AFP::Iondst)
		Inter*=_NbrePrem->second;
    };
//
    return(Inter);
};
