#ifndef INOUT_HPP
#define INOUT_HPP
#include <iostream>
#include <iomanip>
#include <fstream>
#include <string>
#include <vector>
#include <list>
/*****************************************************************/
inline string int2str(int i){
    /*Given an integer, this function returns the corresponding  */
    /* string.                                                   */
    /*G. Marcou                                                  */
    ostringstream Snum;
    Snum << i;
    return(Snum.str());
};
/*****************************************************************/
inline string dbl2str(double d,int prec, int width){
    /* Given a double, this function returns the corresponding   */
    /* formated string.                                          */
    /*G. Marcou                                                  */
    ostringstream Sdbl;
    Sdbl << setprecision(prec) << fixed << setw(width) << d;
    return(Sdbl.str());
};
/*****************************************************************/
inline int str2int(string s){
  /*Given an integer, this function returns the corresponding  */
  /* string.                                                   */
  /*G. Marcou                                                  */
  int i;
  istringstream Snum;
  Snum.str(s);
  Snum >> i;
  return(i);
};
/*****************************************************************/
inline double str2dbl(string s){
    /* Given a double, this function returns the corresponding   */
    /* formated string.                                          */
    /*G. Marcou                                                  */
    istringstream Sdbl;
    double d;
    Sdbl.str(s);
    Sdbl >> d;
    return(d);
};
/*****************************************************************/
class NexusTree{
public:
  NexusTree(int n){
    NexusTree::nrows=n;
  };
/*****************************************************************/
void NexusTreeOut(int, int result[][2], double linkdist[], string, vector<string>);
/*****************************************************************/
/* Nexus tree format output for C cluster library hirarchical    */
/* clusturing output. Output on parameter 4.                     */
/* G. Marcou                                                     */
/*****************************************************************/
/*****************************************************************/
void NexusTreeOut(int, int result[][2], double linkdist[], vector<string>);
/*****************************************************************/
/* Nexus tree format output for C cluster library hirarchical    */
/* clusturing output. Output on stdout.                          */
/* G. Marcou                                                     */
/*****************************************************************/
private:
  int nrows;//Number of leafs of the tree
  int results[nrows][2];
  double distance[nrows];
  vector<string> NodeNames;
};
#endif
