/*****************************************************************/
void NexusTreeOut(int nrows, int result[][2],
		  double linkdist[],string OutName, vector<string> ListEle){
/*****************************************************************/
/* Nexus tree format output for C cluster library hirarchical    */
/* clusturing output. Output on OutName.                         */
/* G. Marcou                                                     */
/*****************************************************************/
//
    int i,j;
    string tree;//tree string
    vector<string> vtree;//node tree string
    bool *_vis,*_finished;//is a node already visited or finished?
    _vis=new bool [nrows-1];
    _finished=new bool [nrows-1];
    list<int> path;//trail in the tree
//
//initialization
    for(i=0;i<nrows-1;++i){
	_vis[i]=false;
	_finished[i]=false;
    };
//
    i=0;//node index
    while(i<(nrows-1)){
	if(!_vis[i]){//this node was never visited 
	    _vis[i]=true;
	    j=0;//the leftmost branch
	    tree+="(";
	    if(result[i][j]>=0){//This is a leaf
		tree+=int2str(result[i][j]+1);
		tree+=":"+dbl2str(linkdist[i]*100,3,4);
	    }else{//follow the branch
		if(!_finished[-result[i][j]-1]){
		    path.push_back(i);
		    i=-result[i][j]-1;
		}else{//if the branch was already parsed add the output
		    tree+=vtree.at(-result[i][j]-1);
		    tree+=":"+dbl2str(linkdist[i]*100,3,4);
		};
		continue;
	    };
	} else {//This node was already visited
	    j=1;//The tree is binary. This is the rightmost branch 
	    if(!_finished[i]){//if it was not finished
		tree+=",";
		_finished[i]=true;
		if(result[i][j]>=0){//This is a leaf
		    tree+=int2str(result[i][j]+1);
		    tree+=":"+dbl2str(linkdist[i]*100,3,4);
		}else{//follow the path
		    if(!_finished[-result[i][j]-1]){
			path.push_back(i);
			i=-result[i][j]-1;
		    }else{//if the next node was already parsed add it
			tree+=vtree.at(-result[i][j]-1);
			tree+=":"+dbl2str(linkdist[i]*100,3,4);
		    };
		};
		continue;
	    };
	    if(_finished[i]){//if the current node was finished
		if(!tree.empty()){//nothing to add
		    tree+=")";
		    tree+=":"+dbl2str(linkdist[path.back()]*100,3,4);
		};
		if(path.empty()){//nothing to go back to
		    if(!tree.empty()){
			vtree.push_back(tree);
			tree.clear();
		    };
		    i++;//go to the next node
		}else{//go back to the parent node
		    i=path.back();
		    path.pop_back();
		};
	    };
	};
    };
    tree=vtree.back();
    tree+=";";
//Nexus format litterature
    ofstream OutTreeFile;
    OutTreeFile.open(OutName.c_str());
    OutTreeFile << "#NEXUS" << endl;
    OutTreeFile << "BEGIN TREES;" << endl;
    OutTreeFile << "[!]" << endl;
    OutTreeFile << "\t TRANSLATE" << endl;
    for(i=0;i<nrows-1;++i)
	OutTreeFile << "\t \t " << i+1 << "\t" << ListEle[i] << "," << endl;
    OutTreeFile << "\t \t " << i+1 << "\t" << ListEle[i] << endl;
    OutTreeFile << "\t \t ;" << endl;
    OutTreeFile << "\t TREE " << OutName << " = ";
    OutTreeFile << tree << endl;
    OutTreeFile << "ENDBLOCK;" << endl;
    OutTreeFile.close();
//
    return;
};
/*****************************************************************/
void NexusTreeOut(int nrows, int result[][2],
		  double linkdist[],vector<string> ListEle){
/*****************************************************************/
/* Nexus tree format output for C cluster library hirarchical    */
/* clusturing output. Output on stdout.                          */
/* G. Marcou                                                     */
/*****************************************************************/
//
    int i,j;
    string tree;//tree string
    vector<string> vtree;//node tree string
    bool *_vis,*_finished;//is a node already visited or finished?
    _vis=new bool [nrows-1];
    _finished=new bool [nrows-1];
    list<int> path;//trail in the tree
//
//initialization
    for(i=0;i<nrows-1;++i){
	_vis[i]=false;
	_finished[i]=false;
    };
//
    i=0;//node index
    while(i<(nrows-1)){
	if(!_vis[i]){//this node was never visited 
	    _vis[i]=true;
	    j=0;//the leftmost branch
	    tree+="(";
	    if(result[i][j]>=0){//This is a leaf
		tree+=int2str(result[i][j]+1);
		tree+=":"+dbl2str(linkdist[i]*100,3,4);
	    }else{//follow the branch
		if(!_finished[-result[i][j]-1]){
		    path.push_back(i);
		    i=-result[i][j]-1;
		}else{//if the branch was already parsed add the output
		    tree+=vtree.at(-result[i][j]-1);
		    tree+=":"+dbl2str(linkdist[i]*100,3,4);
		};
		continue;
	    };
	} else {//This node was already visited
	    j=1;//The tree is binary. This is the rightmost branch 
	    if(!_finished[i]){//if it was not finished
		tree+=",";
		_finished[i]=true;
		if(result[i][j]>=0){//This is a leaf
		    tree+=int2str(result[i][j]+1);
		    tree+=":"+dbl2str(linkdist[i]*100,3,4);
		}else{//follow the path
		    if(!_finished[-result[i][j]-1]){
			path.push_back(i);
			i=-result[i][j]-1;
		    }else{//if the next node was already parsed add it
			tree+=vtree.at(-result[i][j]-1);
			tree+=":"+dbl2str(linkdist[i]*100,3,4);
		    };
		};
		continue;
	    };
	    if(_finished[i]){//if the current node was finished
		if(!tree.empty()){//nothing to add
		    tree+=")";
		    tree+=":"+dbl2str(linkdist[path.back()]*100,3,4);
		};
		if(path.empty()){//nothing to go back to
		    if(!tree.empty()){
			vtree.push_back(tree);
			tree.clear();
		    };
		    i++;//go to the next node
		}else{//go back to the parent node
		    i=path.back();
		    path.pop_back();
		};
	    };
	};
    };
    tree=vtree.back();
    tree+=";";
//Nexus format litterature
    cout << "#NEXUS" << endl;
    cout << "BEGIN TREES;" << endl;
    cout << "[!]" << endl;
    cout << "\t TRANSLATE" << endl;
    for(i=0;i<nrows-1;++i)
	cout << "\t \t " << i+1 << "\t" << ListEle[i] << "," << endl;
    cout << "\t \t " << i+1 << "\t" << ListEle[i] << endl;
    cout << "\t \t ;" << endl;
    cout << "\t TREE USER = ";
    cout << tree << endl;
    cout << "ENDBLOCK;" << endl;
//
    return;
};
